// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey_admin.proto

#include "google/cloud/kms/v1/autokey_admin_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace kms_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AutokeyAdminConnectionIdempotencyPolicy::
    ~AutokeyAdminConnectionIdempotencyPolicy() = default;

std::unique_ptr<AutokeyAdminConnectionIdempotencyPolicy>
AutokeyAdminConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AutokeyAdminConnectionIdempotencyPolicy>(*this);
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::UpdateAutokeyConfig(
    google::cloud::kms::v1::UpdateAutokeyConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::GetAutokeyConfig(
    google::cloud::kms::v1::GetAutokeyConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::ShowEffectiveAutokeyConfig(
    google::cloud::kms::v1::ShowEffectiveAutokeyConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutokeyAdminConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<AutokeyAdminConnectionIdempotencyPolicy>
MakeDefaultAutokeyAdminConnectionIdempotencyPolicy() {
  return std::make_unique<AutokeyAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1
}  // namespace cloud
}  // namespace google
