// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_INTERNAL_SERVICE_ENDPOINT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_INTERNAL_SERVICE_ENDPOINT_H

#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <string>

namespace google {
namespace cloud {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace internal {

/**
 * Returns the default endpoint, respecting the `UniverseDomainOption`.
 *
 * For example:
 *
 * @code
 * auto options = Options{}.set<UniverseDomainOption>("my-ud.net");
 * auto endpoint = UniverseDomainEndpoint("foo.googleapis.com", options);
 * EXPECT_EQ(endpoint, "foo.my-ud.net");
 * @endcode
 */
std::string UniverseDomainEndpoint(std::string gdu_endpoint,
                                   Options const& options);

}  // namespace internal
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_INTERNAL_SERVICE_ENDPOINT_H
