// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/aws_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_MOCKS_MOCK_AWS_CLUSTERS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_MOCKS_MOCK_AWS_CLUSTERS_CONNECTION_H

#include "google/cloud/gkemulticloud/v1/aws_clusters_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace gkemulticloud_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `AwsClustersConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `AwsClustersClient`. To do so,
 * construct an object of type `AwsClustersClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockAwsClustersConnection
    : public gkemulticloud_v1::AwsClustersConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateAwsCluster(Matcher<google::cloud::gkemulticloud::v1::CreateAwsClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>,
              CreateAwsCluster,
              (google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateAwsCluster(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateAwsCluster,
              (NoAwaitTag,
               google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateAwsCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>,
              CreateAwsCluster,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateAwsCluster(Matcher<google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>,
              UpdateAwsCluster,
              (google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateAwsCluster(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateAwsCluster,
              (NoAwaitTag,
               google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateAwsCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>,
              UpdateAwsCluster,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>, GetAwsCluster,
      (google::cloud::gkemulticloud::v1::GetAwsClusterRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::gkemulticloud::v1::AwsCluster>),
      ListAwsClusters,
      (google::cloud::gkemulticloud::v1::ListAwsClustersRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteAwsCluster(Matcher<google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>,
      DeleteAwsCluster,
      (google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteAwsCluster(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteAwsCluster,
              (NoAwaitTag,
               google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteAwsCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>,
      DeleteAwsCluster, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::gkemulticloud::v1::
                           GenerateAwsClusterAgentTokenResponse>,
              GenerateAwsClusterAgentToken,
              (google::cloud::gkemulticloud::v1::
                   GenerateAwsClusterAgentTokenRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenResponse>,
      GenerateAwsAccessToken,
      (google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateAwsNodePool(Matcher<google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>,
              CreateAwsNodePool,
              (google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateAwsNodePool(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateAwsNodePool,
              (NoAwaitTag,
               google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateAwsNodePool(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>,
              CreateAwsNodePool,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateAwsNodePool(Matcher<google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>,
              UpdateAwsNodePool,
              (google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateAwsNodePool(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateAwsNodePool,
              (NoAwaitTag,
               google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateAwsNodePool(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>,
              UpdateAwsNodePool,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RollbackAwsNodePoolUpdate(Matcher<google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>,
      RollbackAwsNodePoolUpdate,
      (google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, RollbackAwsNodePoolUpdate(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, RollbackAwsNodePoolUpdate,
      (NoAwaitTag,
       google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RollbackAwsNodePoolUpdate(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>,
              RollbackAwsNodePoolUpdate,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>, GetAwsNodePool,
      (google::cloud::gkemulticloud::v1::GetAwsNodePoolRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::gkemulticloud::v1::AwsNodePool>),
      ListAwsNodePools,
      (google::cloud::gkemulticloud::v1::ListAwsNodePoolsRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteAwsNodePool(Matcher<google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>,
      DeleteAwsNodePool,
      (google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteAwsNodePool(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteAwsNodePool,
              (NoAwaitTag,
               google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteAwsNodePool(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>,
      DeleteAwsNodePool, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkemulticloud::v1::AwsOpenIdConfig>,
      GetAwsOpenIdConfig,
      (google::cloud::gkemulticloud::v1::GetAwsOpenIdConfigRequest const&
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::gkemulticloud::v1::AwsJsonWebKeys>,
              GetAwsJsonWebKeys,
              (google::cloud::gkemulticloud::v1::GetAwsJsonWebKeysRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkemulticloud::v1::AwsServerConfig>,
      GetAwsServerConfig,
      (google::cloud::gkemulticloud::v1::GetAwsServerConfigRequest const&
           request),
      (override));

  MOCK_METHOD((StreamRange<google::longrunning::Operation>), ListOperations,
              (google::longrunning::ListOperationsRequest request), (override));

  MOCK_METHOD(StatusOr<google::longrunning::Operation>, GetOperation,
              (google::longrunning::GetOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteOperation,
              (google::longrunning::DeleteOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, CancelOperation,
              (google::longrunning::CancelOperationRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_MOCKS_MOCK_AWS_CLUSTERS_CONNECTION_H
