// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/azure_service.proto

#include "google/cloud/gkemulticloud/v1/azure_clusters_connection.h"
#include "google/cloud/gkemulticloud/v1/azure_clusters_options.h"
#include "google/cloud/gkemulticloud/v1/internal/azure_clusters_connection_impl.h"
#include "google/cloud/gkemulticloud/v1/internal/azure_clusters_option_defaults.h"
#include "google/cloud/gkemulticloud/v1/internal/azure_clusters_stub_factory.h"
#include "google/cloud/gkemulticloud/v1/internal/azure_clusters_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkemulticloud_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AzureClustersConnection::~AzureClustersConnection() = default;

future<StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>
AzureClustersConnection::CreateAzureClient(
    google::cloud::gkemulticloud::v1::CreateAzureClientRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::CreateAzureClient(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::CreateAzureClientRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>
AzureClustersConnection::CreateAzureClient(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureClient>
AzureClustersConnection::GetAzureClient(
    google::cloud::gkemulticloud::v1::GetAzureClientRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::gkemulticloud::v1::AzureClient>
AzureClustersConnection::ListAzureClients(
    google::cloud::gkemulticloud::v1::
        ListAzureClientsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkemulticloud::v1::AzureClient>>();
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AzureClustersConnection::DeleteAzureClient(
    google::cloud::gkemulticloud::v1::DeleteAzureClientRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::DeleteAzureClient(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::DeleteAzureClientRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AzureClustersConnection::DeleteAzureClient(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
AzureClustersConnection::CreateAzureCluster(
    google::cloud::gkemulticloud::v1::CreateAzureClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::CreateAzureCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::CreateAzureClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
AzureClustersConnection::CreateAzureCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
AzureClustersConnection::UpdateAzureCluster(
    google::cloud::gkemulticloud::v1::UpdateAzureClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::UpdateAzureCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::UpdateAzureClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
AzureClustersConnection::UpdateAzureCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>
AzureClustersConnection::GetAzureCluster(
    google::cloud::gkemulticloud::v1::GetAzureClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::gkemulticloud::v1::AzureCluster>
AzureClustersConnection::ListAzureClusters(
    google::cloud::gkemulticloud::v1::
        ListAzureClustersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkemulticloud::v1::AzureCluster>>();
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AzureClustersConnection::DeleteAzureCluster(
    google::cloud::gkemulticloud::v1::DeleteAzureClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::DeleteAzureCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::DeleteAzureClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AzureClustersConnection::DeleteAzureCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<
    google::cloud::gkemulticloud::v1::GenerateAzureClusterAgentTokenResponse>
AzureClustersConnection::GenerateAzureClusterAgentToken(
    google::cloud::gkemulticloud::v1::
        GenerateAzureClusterAgentTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenResponse>
AzureClustersConnection::GenerateAzureAccessToken(
    google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
AzureClustersConnection::CreateAzureNodePool(
    google::cloud::gkemulticloud::v1::CreateAzureNodePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::CreateAzureNodePool(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::CreateAzureNodePoolRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
AzureClustersConnection::CreateAzureNodePool(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
AzureClustersConnection::UpdateAzureNodePool(
    google::cloud::gkemulticloud::v1::UpdateAzureNodePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::UpdateAzureNodePool(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::UpdateAzureNodePoolRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
AzureClustersConnection::UpdateAzureNodePool(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>
AzureClustersConnection::GetAzureNodePool(
    google::cloud::gkemulticloud::v1::GetAzureNodePoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::gkemulticloud::v1::AzureNodePool>
AzureClustersConnection::ListAzureNodePools(
    google::cloud::gkemulticloud::v1::
        ListAzureNodePoolsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkemulticloud::v1::AzureNodePool>>();
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AzureClustersConnection::DeleteAzureNodePool(
    google::cloud::gkemulticloud::v1::DeleteAzureNodePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AzureClustersConnection::DeleteAzureNodePool(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::DeleteAzureNodePoolRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AzureClustersConnection::DeleteAzureNodePool(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureOpenIdConfig>
AzureClustersConnection::GetAzureOpenIdConfig(
    google::cloud::gkemulticloud::v1::GetAzureOpenIdConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::gkemulticloud::v1::AzureJsonWebKeys>
AzureClustersConnection::GetAzureJsonWebKeys(
    google::cloud::gkemulticloud::v1::GetAzureJsonWebKeysRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::gkemulticloud::v1::AzureServerConfig>
AzureClustersConnection::GetAzureServerConfig(
    google::cloud::gkemulticloud::v1::GetAzureServerConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
AzureClustersConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation> AzureClustersConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AzureClustersConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AzureClustersConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<AzureClustersConnection> MakeAzureClustersConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 AzureClustersPolicyOptionList>(options,
                                                                __func__);
  options = gkemulticloud_v1_internal::AzureClustersDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = gkemulticloud_v1_internal::CreateDefaultAzureClustersStub(
      std::move(auth), options);
  return gkemulticloud_v1_internal::MakeAzureClustersTracingConnection(
      std::make_shared<gkemulticloud_v1_internal::AzureClustersConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1
}  // namespace cloud
}  // namespace google
