// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/azure_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AZURE_CLUSTERS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AZURE_CLUSTERS_CLIENT_H

#include "google/cloud/gkemulticloud/v1/azure_clusters_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace gkemulticloud_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The AzureClusters API provides a single centrally managed service
/// to create and manage Anthos clusters that run on Azure infrastructure.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AzureClustersClient {
 public:
  explicit AzureClustersClient(
      std::shared_ptr<AzureClustersConnection> connection, Options opts = {});
  ~AzureClustersClient();

  ///@{
  /// @name Copy and move support
  AzureClustersClient(AzureClustersClient const&) = default;
  AzureClustersClient& operator=(AzureClustersClient const&) = default;
  AzureClustersClient(AzureClustersClient&&) = default;
  AzureClustersClient& operator=(AzureClustersClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AzureClustersClient const& a,
                         AzureClustersClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AzureClustersClient const& a,
                         AzureClustersClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
  /// resource on a given Google Cloud project and region.
  ///
  /// `AzureClient` resources hold client authentication
  /// information needed by the Anthos Multicloud API to manage Azure resources
  /// on your Azure subscription on your behalf.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param parent  Required. The parent location where this
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource will be
  ///  created.
  ///  @n
  ///  Location names are formatted as `projects/<project-id>/locations/<region>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param azure_client  Required. The specification of the
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to create.
  /// @param azure_client_id  Required. A client provided ID the resource. Must be unique within the
  ///  parent resource.
  ///  @n
  ///  The provided ID will be part of the
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource name
  ///  formatted as
  ///  `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
  ///  @n
  ///  Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureClient] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.CreateAzureClientRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L702}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>
  CreateAzureClient(
      std::string const& parent,
      google::cloud::gkemulticloud::v1::AzureClient const& azure_client,
      std::string const& azure_client_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureClient
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAzureClient(
      NoAwaitTag, std::string const& parent,
      google::cloud::gkemulticloud::v1::AzureClient const& azure_client,
      std::string const& azure_client_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
  /// resource on a given Google Cloud project and region.
  ///
  /// `AzureClient` resources hold client authentication
  /// information needed by the Anthos Multicloud API to manage Azure resources
  /// on your Azure subscription on your behalf.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.CreateAzureClientRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureClient] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.CreateAzureClientRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L702}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>
  CreateAzureClient(
      google::cloud::gkemulticloud::v1::CreateAzureClientRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureClient
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAzureClient(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::CreateAzureClientRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureClient
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>
  CreateAzureClient(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
  ///
  /// @param name  Required. The name of the
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource to
  ///  describe.
  ///  @n
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are
  ///  formatted as
  ///  `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureClient])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.GetAzureClientRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L738}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureClient> GetAzureClient(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAzureClientRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureClient])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.GetAzureClientRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L738}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureClient> GetAzureClient(
      google::cloud::gkemulticloud::v1::GetAzureClientRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
  /// resources on a given Google Cloud project and region.
  ///
  /// @param parent  Required. The parent location which owns this collection of
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources.
  ///  @n
  ///  Location names are formatted as `projects/<project-id>/locations/<region>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud Platform resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AzureClient], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.ListAzureClientsRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L758}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AzureClient> ListAzureClients(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
  /// resources on a given Google Cloud project and region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.ListAzureClientsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AzureClient], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.ListAzureClientsRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L758}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AzureClient> ListAzureClients(
      google::cloud::gkemulticloud::v1::ListAzureClientsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
  /// resource.
  ///
  /// If the client is used by one or more clusters, deletion will
  /// fail and a `FAILED_PRECONDITION` error will be returned.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param name  Required. The resource name the
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to delete.
  ///  @n
  ///  [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are
  ///  formatted as
  ///  `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.DeleteAzureClientRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L800}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureClient(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureClient
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAzureClient(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
  /// resource.
  ///
  /// If the client is used by one or more clusters, deletion will
  /// fail and a `FAILED_PRECONDITION` error will be returned.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.DeleteAzureClientRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureClient]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L401}
  /// [google.cloud.gkemulticloud.v1.DeleteAzureClientRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L800}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureClient(
      google::cloud::gkemulticloud::v1::DeleteAzureClientRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureClient
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAzureClient(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::DeleteAzureClientRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureClient
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureClient(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
  /// resource on a given Google Cloud Platform project and region.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param parent  Required. The parent location where this
  ///  [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource will be
  ///  created.
  ///  @n
  ///  Location names are formatted as `projects/<project-id>/locations/<region>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param azure_cluster  Required. The specification of the
  ///  [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to create.
  /// @param azure_cluster_id  Required. A client provided ID the resource. Must be unique within the
  ///  parent resource.
  ///  @n
  ///  The provided ID will be part of the
  ///  [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource name
  ///  formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
  ///  @n
  ///  Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.CreateAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L309}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
  CreateAzureCluster(
      std::string const& parent,
      google::cloud::gkemulticloud::v1::AzureCluster const& azure_cluster,
      std::string const& azure_cluster_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAzureCluster(
      NoAwaitTag, std::string const& parent,
      google::cloud::gkemulticloud::v1::AzureCluster const& azure_cluster,
      std::string const& azure_cluster_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
  /// resource on a given Google Cloud Platform project and region.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.CreateAzureClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.CreateAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L309}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
  CreateAzureCluster(
      google::cloud::gkemulticloud::v1::CreateAzureClusterRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAzureCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::CreateAzureClusterRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
  CreateAzureCluster(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
  ///
  /// @param azure_cluster  Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
  ///  resource to update.
  /// @param update_mask  Required. Mask of fields to update. At least one path must be supplied in
  ///  this field. The elements of the repeated paths field can only include these
  ///  fields from [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]:
  ///  @n
  ///   *   `description`.
  ///   *   `azureClient`.
  ///   *   `control_plane.version`.
  ///   *   `control_plane.vm_size`.
  ///   *   `annotations`.
  ///   *   `authorization.admin_users`.
  ///   *   `authorization.admin_groups`.
  ///   *   `control_plane.root_volume.size_gib`.
  ///   *   `azure_services_authentication`.
  ///   *   `azure_services_authentication.tenant_id`.
  ///   *   `azure_services_authentication.application_id`.
  ///   *   `control_plane.proxy_config`.
  ///   *   `control_plane.proxy_config.resource_group_id`.
  ///   *   `control_plane.proxy_config.secret_id`.
  ///   *   `control_plane.ssh_config.authorized_key`.
  ///   *   `logging_config.component_config.enable_components`
  ///   *   `monitoring_config.managed_prometheus_config.enabled`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L345}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
  UpdateAzureCluster(
      google::cloud::gkemulticloud::v1::AzureCluster const& azure_cluster,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAzureCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAzureCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::AzureCluster const& azure_cluster,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L345}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
  UpdateAzureCluster(
      google::cloud::gkemulticloud::v1::UpdateAzureClusterRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAzureCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAzureCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::UpdateAzureClusterRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAzureCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>
  UpdateAzureCluster(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
  ///
  /// @param name  Required. The name of the
  ///  [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to
  ///  describe.
  ///  @n
  ///  `AzureCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud Platform resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureCluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.GetAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L379}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureCluster> GetAzureCluster(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAzureClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureCluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.GetAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L379}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureCluster> GetAzureCluster(
      google::cloud::gkemulticloud::v1::GetAzureClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
  /// resources on a given Google Cloud project and region.
  ///
  /// @param parent  Required. The parent location which owns this collection of
  ///  [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources.
  ///  @n
  ///  Location names are formatted as `projects/<project-id>/locations/<region>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud Platform resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AzureCluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.ListAzureClustersRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L398}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AzureCluster> ListAzureClusters(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
  /// resources on a given Google Cloud project and region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.ListAzureClustersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AzureCluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.ListAzureClustersRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L398}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AzureCluster> ListAzureClusters(
      google::cloud::gkemulticloud::v1::ListAzureClustersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
  ///
  /// Fails if the cluster has one or more associated
  /// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param name  Required. The resource name the
  ///  [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to delete.
  ///  @n
  ///  `AzureCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud Platform resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L440}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureCluster(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAzureCluster(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
  ///
  /// Fails if the cluster has one or more associated
  /// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L440}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureCluster(
      google::cloud::gkemulticloud::v1::DeleteAzureClusterRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAzureCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::DeleteAzureClusterRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureCluster(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Generates an access token for a cluster agent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L858}
  /// [google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenResponse]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L895}
  ///
  // clang-format on
  StatusOr<
      google::cloud::gkemulticloud::v1::GenerateAzureClusterAgentTokenResponse>
  GenerateAzureClusterAgentToken(
      google::cloud::gkemulticloud::v1::
          GenerateAzureClusterAgentTokenRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Generates a short-lived access token to authenticate to a given
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L830}
  /// [google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L849}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenResponse>
  GenerateAzureAccessToken(
      google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool],
  /// attached to a given
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param parent  Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
  ///  resource where this node pool will be created.
  ///  @n
  ///  `AzureCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param azure_node_pool  Required. The specification of the
  ///  [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to create.
  /// @param azure_node_pool_id  Required. A client provided ID the resource. Must be unique within the
  ///  parent resource.
  ///  @n
  ///  The provided ID will be part of the
  ///  [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource name
  ///  formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
  ///  @n
  ///  Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L484}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
  CreateAzureNodePool(
      std::string const& parent,
      google::cloud::gkemulticloud::v1::AzureNodePool const& azure_node_pool,
      std::string const& azure_node_pool_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAzureNodePool(
      NoAwaitTag, std::string const& parent,
      google::cloud::gkemulticloud::v1::AzureNodePool const& azure_node_pool,
      std::string const& azure_node_pool_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool],
  /// attached to a given
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L484}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
  CreateAzureNodePool(
      google::cloud::gkemulticloud::v1::CreateAzureNodePoolRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAzureNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::CreateAzureNodePoolRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAzureNodePool
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
  CreateAzureNodePool(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
  ///
  /// @param azure_node_pool  Required. The [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
  ///  resource to update.
  /// @param update_mask  Required. Mask of fields to update. At least one path must be supplied in
  ///  this field. The elements of the repeated paths field can only include these
  ///  fields from [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]:
  ///  @n
  ///   *.  `annotations`.
  ///   *   `version`.
  ///   *   `autoscaling.min_node_count`.
  ///   *   `autoscaling.max_node_count`.
  ///   *   `config.ssh_config.authorized_key`.
  ///   *   `management.auto_repair`.
  ///   *   `management`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L521}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
  UpdateAzureNodePool(
      google::cloud::gkemulticloud::v1::AzureNodePool const& azure_node_pool,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAzureNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAzureNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::AzureNodePool const& azure_node_pool,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.AzureNodePool] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L521}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
  UpdateAzureNodePool(
      google::cloud::gkemulticloud::v1::UpdateAzureNodePoolRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAzureNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAzureNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::UpdateAzureNodePoolRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAzureNodePool
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>
  UpdateAzureNodePool(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
  ///
  /// @param name  Required. The name of the
  ///  [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource to
  ///  describe.
  ///  @n
  ///  `AzureNodePool` names are formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureNodePool])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L545}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool> GetAzureNodePool(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Describes a specific
  /// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureNodePool])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L545}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool> GetAzureNodePool(
      google::cloud::gkemulticloud::v1::GetAzureNodePoolRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
  /// resources on a given
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
  ///
  /// @param parent  Required. The parent `AzureCluster` which owns this collection of
  ///  [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
  ///  @n
  ///  `AzureCluster` names are formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AzureNodePool], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L564}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AzureNodePool>
  ListAzureNodePools(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
  /// resources on a given
  /// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkemulticloud.v1.AzureNodePool], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureCluster]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L34}
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L564}
  ///
  // clang-format on
  StreamRange<google::cloud::gkemulticloud::v1::AzureNodePool>
  ListAzureNodePools(
      google::cloud::gkemulticloud::v1::ListAzureNodePoolsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific
  /// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param name  Required. The resource name the
  ///  [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to delete.
  ///  @n
  ///  `AzureNodePool` names are formatted as
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L607}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureNodePool(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAzureNodePool(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a specific
  /// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
  ///
  /// If successful, the response contains a newly created
  /// [Operation][google.longrunning.Operation] resource that can be
  /// described to track the status of the operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkemulticloud.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureNodePool]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L494}
  /// [google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L607}
  /// [google.cloud.gkemulticloud.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/common_resources.proto#L80}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureNodePool(
      google::cloud::gkemulticloud::v1::DeleteAzureNodePoolRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureNodePool
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAzureNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::DeleteAzureNodePoolRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAzureNodePool
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAzureNodePool(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Gets the OIDC discovery document for the cluster.
  /// See the
  /// [OpenID Connect Discovery 1.0
  /// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
  /// for details.
  ///
  /// @param azure_cluster  Required. The AzureCluster, which owns the OIDC discovery document.
  ///  Format:
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureOpenIdConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureOpenIdConfig]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L681}
  /// [google.cloud.gkemulticloud.v1.GetAzureOpenIdConfigRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L654}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureOpenIdConfig>
  GetAzureOpenIdConfig(std::string const& azure_cluster, Options opts = {});

  // clang-format off
  ///
  /// Gets the OIDC discovery document for the cluster.
  /// See the
  /// [OpenID Connect Discovery 1.0
  /// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
  /// for details.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAzureOpenIdConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureOpenIdConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureOpenIdConfig]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L681}
  /// [google.cloud.gkemulticloud.v1.GetAzureOpenIdConfigRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L654}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureOpenIdConfig>
  GetAzureOpenIdConfig(
      google::cloud::gkemulticloud::v1::GetAzureOpenIdConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the public component of the cluster signing keys in
  /// JSON Web Key format.
  ///
  /// @param azure_cluster  Required. The AzureCluster, which owns the JsonWebKeys.
  ///  Format:
  ///  `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureJsonWebKeys])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureJsonWebKeys]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L705}
  /// [google.cloud.gkemulticloud.v1.GetAzureJsonWebKeysRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L670}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureJsonWebKeys>
  GetAzureJsonWebKeys(std::string const& azure_cluster, Options opts = {});

  // clang-format off
  ///
  /// Gets the public component of the cluster signing keys in
  /// JSON Web Key format.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAzureJsonWebKeysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureJsonWebKeys])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureJsonWebKeys]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L705}
  /// [google.cloud.gkemulticloud.v1.GetAzureJsonWebKeysRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L670}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureJsonWebKeys>
  GetAzureJsonWebKeys(
      google::cloud::gkemulticloud::v1::GetAzureJsonWebKeysRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns information, such as supported Azure regions and Kubernetes
  /// versions, on a given Google Cloud location.
  ///
  /// @param name  Required. The name of the
  ///  [AzureServerConfig][google.cloud.gkemulticloud.v1.AzureServerConfig]
  ///  resource to describe.
  ///  @n
  ///  `AzureServerConfig` names are formatted as
  ///  `projects/<project-id>/locations/<region>/azureServerConfig`.
  ///  @n
  ///  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
  ///  for more details on Google Cloud resource names.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureServerConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureServerConfig]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L713}
  /// [google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L683}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureServerConfig>
  GetAzureServerConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns information, such as supported Azure regions and Kubernetes
  /// versions, on a given Google Cloud location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkemulticloud.v1.AzureServerConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkemulticloud.v1.AzureServerConfig]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_resources.proto#L713}
  /// [google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest]: @googleapis_reference_link{google/cloud/gkemulticloud/v1/azure_service.proto#L683}
  ///
  // clang-format on
  StatusOr<google::cloud::gkemulticloud::v1::AzureServerConfig>
  GetAzureServerConfig(
      google::cloud::gkemulticloud::v1::GetAzureServerConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param name  The name of the operation resource to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.DeleteOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param name  The name of the operation resource to be cancelled.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.CancelOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<AzureClustersConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AZURE_CLUSTERS_CLIENT_H
