// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/aws_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AWS_CLUSTERS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AWS_CLUSTERS_CONNECTION_H

#include "google/cloud/gkemulticloud/v1/aws_clusters_connection_idempotency_policy.h"
#include "google/cloud/gkemulticloud/v1/internal/aws_clusters_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/gkemulticloud/v1/aws_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace gkemulticloud_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `AwsClustersConnection`.
class AwsClustersRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<AwsClustersRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `AwsClustersConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AwsClustersLimitedErrorCountRetryPolicy : public AwsClustersRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit AwsClustersLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  AwsClustersLimitedErrorCountRetryPolicy(
      AwsClustersLimitedErrorCountRetryPolicy&& rhs) noexcept
      : AwsClustersLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  AwsClustersLimitedErrorCountRetryPolicy(
      AwsClustersLimitedErrorCountRetryPolicy const& rhs) noexcept
      : AwsClustersLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AwsClustersRetryPolicy> clone() const override {
    return std::make_unique<AwsClustersLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AwsClustersRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      gkemulticloud_v1_internal::AwsClustersRetryTraits>
      impl_;
};

/**
 * A retry policy for `AwsClustersConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AwsClustersLimitedTimeRetryPolicy : public AwsClustersRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit AwsClustersLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  AwsClustersLimitedTimeRetryPolicy(
      AwsClustersLimitedTimeRetryPolicy&& rhs) noexcept
      : AwsClustersLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  AwsClustersLimitedTimeRetryPolicy(
      AwsClustersLimitedTimeRetryPolicy const& rhs) noexcept
      : AwsClustersLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AwsClustersRetryPolicy> clone() const override {
    return std::make_unique<AwsClustersLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AwsClustersRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      gkemulticloud_v1_internal::AwsClustersRetryTraits>
      impl_;
};

/**
 * The `AwsClustersConnection` object for `AwsClustersClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `AwsClustersClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `AwsClustersClient`.
 *
 * To create a concrete instance, see `MakeAwsClustersConnection()`.
 *
 * For mocking, see `gkemulticloud_v1_mocks::MockAwsClustersConnection`.
 */
class AwsClustersConnection {
 public:
  virtual ~AwsClustersConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  CreateAwsCluster(
      google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateAwsCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const& request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  CreateAwsCluster(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  UpdateAwsCluster(
      google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateAwsCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const& request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
  UpdateAwsCluster(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::gkemulticloud::v1::AwsCluster> GetAwsCluster(
      google::cloud::gkemulticloud::v1::GetAwsClusterRequest const& request);

  virtual StreamRange<google::cloud::gkemulticloud::v1::AwsCluster>
  ListAwsClusters(
      google::cloud::gkemulticloud::v1::ListAwsClustersRequest request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsCluster(
      google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteAwsCluster(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const& request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsCluster(google::longrunning::Operation const& operation);

  virtual StatusOr<
      google::cloud::gkemulticloud::v1::GenerateAwsClusterAgentTokenResponse>
  GenerateAwsClusterAgentToken(
      google::cloud::gkemulticloud::v1::
          GenerateAwsClusterAgentTokenRequest const& request);

  virtual StatusOr<
      google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenResponse>
  GenerateAwsAccessToken(
      google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenRequest const&
          request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  CreateAwsNodePool(
      google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateAwsNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const&
          request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  CreateAwsNodePool(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  UpdateAwsNodePool(
      google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateAwsNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const&
          request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  UpdateAwsNodePool(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  RollbackAwsNodePoolUpdate(
      google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> RollbackAwsNodePoolUpdate(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
          request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
  RollbackAwsNodePoolUpdate(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>
  GetAwsNodePool(
      google::cloud::gkemulticloud::v1::GetAwsNodePoolRequest const& request);

  virtual StreamRange<google::cloud::gkemulticloud::v1::AwsNodePool>
  ListAwsNodePools(
      google::cloud::gkemulticloud::v1::ListAwsNodePoolsRequest request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsNodePool(
      google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteAwsNodePool(
      NoAwaitTag,
      google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const&
          request);

  virtual future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
  DeleteAwsNodePool(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::gkemulticloud::v1::AwsOpenIdConfig>
  GetAwsOpenIdConfig(
      google::cloud::gkemulticloud::v1::GetAwsOpenIdConfigRequest const&
          request);

  virtual StatusOr<google::cloud::gkemulticloud::v1::AwsJsonWebKeys>
  GetAwsJsonWebKeys(
      google::cloud::gkemulticloud::v1::GetAwsJsonWebKeysRequest const&
          request);

  virtual StatusOr<google::cloud::gkemulticloud::v1::AwsServerConfig>
  GetAwsServerConfig(
      google::cloud::gkemulticloud::v1::GetAwsServerConfigRequest const&
          request);

  virtual StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

/**
 * A factory function to construct an object of type `AwsClustersConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of AwsClustersClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `AwsClustersConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::gkemulticloud_v1::AwsClustersPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param location Sets the prefix for the default `EndpointOption` value.
 * @param options (optional) Configure the `AwsClustersConnection` created by
 * this function.
 */
std::shared_ptr<AwsClustersConnection> MakeAwsClustersConnection(
    std::string const& location, Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_AWS_CLUSTERS_CONNECTION_H
