// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/attached_service.proto

#include "google/cloud/gkemulticloud/v1/attached_clusters_connection.h"
#include "google/cloud/gkemulticloud/v1/attached_clusters_options.h"
#include "google/cloud/gkemulticloud/v1/internal/attached_clusters_connection_impl.h"
#include "google/cloud/gkemulticloud/v1/internal/attached_clusters_option_defaults.h"
#include "google/cloud/gkemulticloud/v1/internal/attached_clusters_stub_factory.h"
#include "google/cloud/gkemulticloud/v1/internal/attached_clusters_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkemulticloud_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AttachedClustersConnection::~AttachedClustersConnection() = default;

future<StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>
AttachedClustersConnection::CreateAttachedCluster(
    google::cloud::gkemulticloud::v1::CreateAttachedClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AttachedClustersConnection::CreateAttachedCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::CreateAttachedClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>
AttachedClustersConnection::CreateAttachedCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>
AttachedClustersConnection::UpdateAttachedCluster(
    google::cloud::gkemulticloud::v1::UpdateAttachedClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AttachedClustersConnection::UpdateAttachedCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::UpdateAttachedClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>
AttachedClustersConnection::UpdateAttachedCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>
AttachedClustersConnection::ImportAttachedCluster(
    google::cloud::gkemulticloud::v1::ImportAttachedClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AttachedClustersConnection::ImportAttachedCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::ImportAttachedClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>
AttachedClustersConnection::ImportAttachedCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gkemulticloud::v1::AttachedCluster>
AttachedClustersConnection::GetAttachedCluster(
    google::cloud::gkemulticloud::v1::GetAttachedClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::gkemulticloud::v1::AttachedCluster>
AttachedClustersConnection::ListAttachedClusters(
    google::cloud::gkemulticloud::v1::
        ListAttachedClustersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkemulticloud::v1::AttachedCluster>>();
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AttachedClustersConnection::DeleteAttachedCluster(
    google::cloud::gkemulticloud::v1::DeleteAttachedClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AttachedClustersConnection::DeleteAttachedCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::DeleteAttachedClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AttachedClustersConnection::DeleteAttachedCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gkemulticloud::v1::AttachedServerConfig>
AttachedClustersConnection::GetAttachedServerConfig(
    google::cloud::gkemulticloud::v1::GetAttachedServerConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::gkemulticloud::v1::
             GenerateAttachedClusterInstallManifestResponse>
AttachedClustersConnection::GenerateAttachedClusterInstallManifest(
    google::cloud::gkemulticloud::v1::
        GenerateAttachedClusterInstallManifestRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<
    google::cloud::gkemulticloud::v1::GenerateAttachedClusterAgentTokenResponse>
AttachedClustersConnection::GenerateAttachedClusterAgentToken(
    google::cloud::gkemulticloud::v1::
        GenerateAttachedClusterAgentTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
AttachedClustersConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
AttachedClustersConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AttachedClustersConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AttachedClustersConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<AttachedClustersConnection> MakeAttachedClustersConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 AttachedClustersPolicyOptionList>(options,
                                                                   __func__);
  options = gkemulticloud_v1_internal::AttachedClustersDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = gkemulticloud_v1_internal::CreateDefaultAttachedClustersStub(
      std::move(auth), options);
  return gkemulticloud_v1_internal::MakeAttachedClustersTracingConnection(
      std::make_shared<
          gkemulticloud_v1_internal::AttachedClustersConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1
}  // namespace cloud
}  // namespace google
