// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkeconnect/gateway/v1/control.proto

#include "google/cloud/gkeconnect/gateway/v1/gateway_control_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkeconnect_gateway_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GatewayControlClient::GatewayControlClient(
    std::shared_ptr<GatewayControlConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
GatewayControlClient::~GatewayControlClient() = default;

StatusOr<google::cloud::gkeconnect::gateway::v1::GenerateCredentialsResponse>
GatewayControlClient::GenerateCredentials(
    google::cloud::gkeconnect::gateway::v1::GenerateCredentialsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateCredentials(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkeconnect_gateway_v1
}  // namespace cloud
}  // namespace google
