// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#include "google/cloud/gkebackup/v1/internal/backup_for_gke_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/gkebackup/v1/gkebackup.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace gkebackup_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackupForGKEMetadata::BackupForGKEMetadata(
    std::shared_ptr<BackupForGKEStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncCreateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateBackupPlan(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::CreateBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBackupPlan(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::ListBackupPlansResponse>
BackupForGKEMetadata::ListBackupPlans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListBackupPlansRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackupPlans(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKEMetadata::GetBackupPlan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupPlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackupPlan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncUpdateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("backup_plan.name=",
                           internal::UrlEncode(request.backup_plan().name())));
  return child_->AsyncUpdateBackupPlan(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::UpdateBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("backup_plan.name=",
                           internal::UrlEncode(request.backup_plan().name())));
  return child_->UpdateBackupPlan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncDeleteBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteBackupPlan(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::DeleteBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackupPlan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::CreateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBackup(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::ListBackupsResponse>
BackupForGKEMetadata::ListBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListBackupsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackups(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::Backup> BackupForGKEMetadata::GetBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncUpdateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("backup.name=",
                           internal::UrlEncode(request.backup().name())));
  return child_->AsyncUpdateBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::UpdateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("backup.name=",
                           internal::UrlEncode(request.backup().name())));
  return child_->UpdateBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::DeleteBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackup(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeBackupsResponse>
BackupForGKEMetadata::ListVolumeBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListVolumeBackupsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListVolumeBackups(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKEMetadata::GetVolumeBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetVolumeBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncCreateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateRestorePlan(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation>
BackupForGKEMetadata::CreateRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateRestorePlan(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::ListRestorePlansResponse>
BackupForGKEMetadata::ListRestorePlans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListRestorePlansRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListRestorePlans(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKEMetadata::GetRestorePlan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetRestorePlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetRestorePlan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncUpdateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("restore_plan.name=",
                           internal::UrlEncode(request.restore_plan().name())));
  return child_->AsyncUpdateRestorePlan(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation>
BackupForGKEMetadata::UpdateRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("restore_plan.name=",
                           internal::UrlEncode(request.restore_plan().name())));
  return child_->UpdateRestorePlan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncDeleteRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteRestorePlan(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation>
BackupForGKEMetadata::DeleteRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteRestorePlan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncCreateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateRestore(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::CreateRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateRestore(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::ListRestoresResponse>
BackupForGKEMetadata::ListRestores(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListRestoresRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListRestores(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::Restore>
BackupForGKEMetadata::GetRestore(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetRestoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetRestore(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncUpdateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("restore.name=",
                           internal::UrlEncode(request.restore().name())));
  return child_->AsyncUpdateRestore(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::UpdateRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("restore.name=",
                           internal::UrlEncode(request.restore().name())));
  return child_->UpdateRestore(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncDeleteRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteRestore(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::DeleteRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteRestore(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeRestoresResponse>
BackupForGKEMetadata::ListVolumeRestores(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListVolumeRestoresRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListVolumeRestores(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKEMetadata::GetVolumeRestore(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetVolumeRestoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetVolumeRestore(context, options, request);
}

StatusOr<google::cloud::gkebackup::v1::GetBackupIndexDownloadUrlResponse>
BackupForGKEMetadata::GetBackupIndexDownloadUrl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupIndexDownloadUrlRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("backup=", internal::UrlEncode(request.backup())));
  return child_->GetBackupIndexDownloadUrl(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
BackupForGKEMetadata::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location> BackupForGKEMetadata::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetLocation(context, options, request);
}

StatusOr<google::iam::v1::Policy> BackupForGKEMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> BackupForGKEMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
BackupForGKEMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
BackupForGKEMetadata::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> BackupForGKEMetadata::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetOperation(context, options, request);
}

Status BackupForGKEMetadata::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteOperation(context, options, request);
}

Status BackupForGKEMetadata::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CancelOperation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKEMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> BackupForGKEMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void BackupForGKEMetadata::SetMetadata(grpc::ClientContext& context,
                                       Options const& options,
                                       std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void BackupForGKEMetadata::SetMetadata(grpc::ClientContext& context,
                                       Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1_internal
}  // namespace cloud
}  // namespace google
