// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v2/functions.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_FUNCTIONS_V2_INTERNAL_FUNCTION_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_FUNCTIONS_V2_INTERNAL_FUNCTION_TRACING_CONNECTION_H

#include "google/cloud/functions/v2/function_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace functions_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class FunctionServiceTracingConnection
    : public functions_v2::FunctionServiceConnection {
 public:
  ~FunctionServiceTracingConnection() override = default;

  explicit FunctionServiceTracingConnection(
      std::shared_ptr<functions_v2::FunctionServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::functions::v2::Function> GetFunction(
      google::cloud::functions::v2::GetFunctionRequest const& request) override;

  StreamRange<google::cloud::functions::v2::Function> ListFunctions(
      google::cloud::functions::v2::ListFunctionsRequest request) override;

  future<StatusOr<google::cloud::functions::v2::Function>> CreateFunction(
      google::cloud::functions::v2::CreateFunctionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFunction(
      NoAwaitTag,
      google::cloud::functions::v2::CreateFunctionRequest const& request)
      override;

  future<StatusOr<google::cloud::functions::v2::Function>> CreateFunction(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::functions::v2::Function>> UpdateFunction(
      google::cloud::functions::v2::UpdateFunctionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateFunction(
      NoAwaitTag,
      google::cloud::functions::v2::UpdateFunctionRequest const& request)
      override;

  future<StatusOr<google::cloud::functions::v2::Function>> UpdateFunction(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::functions::v2::OperationMetadata>>
  DeleteFunction(google::cloud::functions::v2::DeleteFunctionRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DeleteFunction(
      NoAwaitTag,
      google::cloud::functions::v2::DeleteFunctionRequest const& request)
      override;

  future<StatusOr<google::cloud::functions::v2::OperationMetadata>>
  DeleteFunction(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::functions::v2::GenerateUploadUrlResponse>
  GenerateUploadUrl(
      google::cloud::functions::v2::GenerateUploadUrlRequest const& request)
      override;

  StatusOr<google::cloud::functions::v2::GenerateDownloadUrlResponse>
  GenerateDownloadUrl(
      google::cloud::functions::v2::GenerateDownloadUrlRequest const& request)
      override;

  StatusOr<google::cloud::functions::v2::ListRuntimesResponse> ListRuntimes(
      google::cloud::functions::v2::ListRuntimesRequest const& request)
      override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

 private:
  std::shared_ptr<functions_v2::FunctionServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<functions_v2::FunctionServiceConnection>
MakeFunctionServiceTracingConnection(
    std::shared_ptr<functions_v2::FunctionServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_FUNCTIONS_V2_INTERNAL_FUNCTION_TRACING_CONNECTION_H
