// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v2/functions.proto

#include "google/cloud/functions/v2/function_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace functions_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

FunctionServiceConnectionIdempotencyPolicy::
    ~FunctionServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<FunctionServiceConnectionIdempotencyPolicy>
FunctionServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<FunctionServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::GetFunction(
    google::cloud::functions::v2::GetFunctionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::ListFunctions(
    google::cloud::functions::v2::ListFunctionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::CreateFunction(
    google::cloud::functions::v2::CreateFunctionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::UpdateFunction(
    google::cloud::functions::v2::UpdateFunctionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::DeleteFunction(
    google::cloud::functions::v2::DeleteFunctionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::GenerateUploadUrl(
    google::cloud::functions::v2::GenerateUploadUrlRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::GenerateDownloadUrl(
    google::cloud::functions::v2::GenerateDownloadUrlRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::ListRuntimes(
    google::cloud::functions::v2::ListRuntimesRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FunctionServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<FunctionServiceConnectionIdempotencyPolicy>
MakeDefaultFunctionServiceConnectionIdempotencyPolicy() {
  return std::make_unique<FunctionServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v2
}  // namespace cloud
}  // namespace google
