// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v2/functions.proto

#include "google/cloud/functions/v2/function_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace functions_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FunctionServiceClient::FunctionServiceClient(
    std::shared_ptr<FunctionServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
FunctionServiceClient::~FunctionServiceClient() = default;

StatusOr<google::cloud::functions::v2::Function>
FunctionServiceClient::GetFunction(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::GetFunctionRequest request;
  request.set_name(name);
  return connection_->GetFunction(request);
}

StatusOr<google::cloud::functions::v2::Function>
FunctionServiceClient::GetFunction(
    google::cloud::functions::v2::GetFunctionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFunction(request);
}

StreamRange<google::cloud::functions::v2::Function>
FunctionServiceClient::ListFunctions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::ListFunctionsRequest request;
  request.set_parent(parent);
  return connection_->ListFunctions(request);
}

StreamRange<google::cloud::functions::v2::Function>
FunctionServiceClient::ListFunctions(
    google::cloud::functions::v2::ListFunctionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFunctions(std::move(request));
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceClient::CreateFunction(
    std::string const& parent,
    google::cloud::functions::v2::Function const& function,
    std::string const& function_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::CreateFunctionRequest request;
  request.set_parent(parent);
  *request.mutable_function() = function;
  request.set_function_id(function_id);
  return connection_->CreateFunction(request);
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::CreateFunction(
    NoAwaitTag, std::string const& parent,
    google::cloud::functions::v2::Function const& function,
    std::string const& function_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::CreateFunctionRequest request;
  request.set_parent(parent);
  *request.mutable_function() = function;
  request.set_function_id(function_id);
  return connection_->CreateFunction(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceClient::CreateFunction(
    google::cloud::functions::v2::CreateFunctionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateFunction(request);
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::CreateFunction(
    NoAwaitTag,
    google::cloud::functions::v2::CreateFunctionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateFunction(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceClient::CreateFunction(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateFunction(operation);
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceClient::UpdateFunction(
    google::cloud::functions::v2::Function const& function,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::UpdateFunctionRequest request;
  *request.mutable_function() = function;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateFunction(request);
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::UpdateFunction(
    NoAwaitTag, google::cloud::functions::v2::Function const& function,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::UpdateFunctionRequest request;
  *request.mutable_function() = function;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateFunction(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceClient::UpdateFunction(
    google::cloud::functions::v2::UpdateFunctionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFunction(request);
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::UpdateFunction(
    NoAwaitTag,
    google::cloud::functions::v2::UpdateFunctionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFunction(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceClient::UpdateFunction(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFunction(operation);
}

future<StatusOr<google::cloud::functions::v2::OperationMetadata>>
FunctionServiceClient::DeleteFunction(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::DeleteFunctionRequest request;
  request.set_name(name);
  return connection_->DeleteFunction(request);
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::DeleteFunction(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::DeleteFunctionRequest request;
  request.set_name(name);
  return connection_->DeleteFunction(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::functions::v2::OperationMetadata>>
FunctionServiceClient::DeleteFunction(
    google::cloud::functions::v2::DeleteFunctionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFunction(request);
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::DeleteFunction(
    NoAwaitTag,
    google::cloud::functions::v2::DeleteFunctionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFunction(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::functions::v2::OperationMetadata>>
FunctionServiceClient::DeleteFunction(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFunction(operation);
}

StatusOr<google::cloud::functions::v2::GenerateUploadUrlResponse>
FunctionServiceClient::GenerateUploadUrl(
    google::cloud::functions::v2::GenerateUploadUrlRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateUploadUrl(request);
}

StatusOr<google::cloud::functions::v2::GenerateDownloadUrlResponse>
FunctionServiceClient::GenerateDownloadUrl(
    google::cloud::functions::v2::GenerateDownloadUrlRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateDownloadUrl(request);
}

StatusOr<google::cloud::functions::v2::ListRuntimesResponse>
FunctionServiceClient::ListRuntimes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::functions::v2::ListRuntimesRequest request;
  request.set_parent(parent);
  return connection_->ListRuntimes(request);
}

StatusOr<google::cloud::functions::v2::ListRuntimesResponse>
FunctionServiceClient::ListRuntimes(
    google::cloud::functions::v2::ListRuntimesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRuntimes(request);
}

StreamRange<google::cloud::location::Location>
FunctionServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::iam::v1::Policy> FunctionServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> FunctionServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FunctionServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
FunctionServiceClient::ListOperations(std::string const& name,
                                      std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
FunctionServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> FunctionServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v2
}  // namespace cloud
}  // namespace google
