// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v1/functions.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_FUNCTIONS_V1_CLOUD_FUNCTIONS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_FUNCTIONS_V1_CLOUD_FUNCTIONS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/functions/v1/functions.grpc.pb.h>
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace functions_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudFunctionsServiceConnectionIdempotencyPolicy {
 public:
  virtual ~CloudFunctionsServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<CloudFunctionsServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency ListFunctions(
      google::cloud::functions::v1::ListFunctionsRequest request);

  virtual google::cloud::Idempotency GetFunction(
      google::cloud::functions::v1::GetFunctionRequest const& request);

  virtual google::cloud::Idempotency CreateFunction(
      google::cloud::functions::v1::CreateFunctionRequest const& request);

  virtual google::cloud::Idempotency UpdateFunction(
      google::cloud::functions::v1::UpdateFunctionRequest const& request);

  virtual google::cloud::Idempotency DeleteFunction(
      google::cloud::functions::v1::DeleteFunctionRequest const& request);

  virtual google::cloud::Idempotency CallFunction(
      google::cloud::functions::v1::CallFunctionRequest const& request);

  virtual google::cloud::Idempotency GenerateUploadUrl(
      google::cloud::functions::v1::GenerateUploadUrlRequest const& request);

  virtual google::cloud::Idempotency GenerateDownloadUrl(
      google::cloud::functions::v1::GenerateDownloadUrlRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);
};

std::unique_ptr<CloudFunctionsServiceConnectionIdempotencyPolicy>
MakeDefaultCloudFunctionsServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_FUNCTIONS_V1_CLOUD_FUNCTIONS_CONNECTION_IDEMPOTENCY_POLICY_H
