// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/v1/internal/eventarc_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/eventarc/v1/eventarc.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace eventarc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EventarcLogging::EventarcLogging(std::shared_ptr<EventarcStub> child,
                                 TracingOptions tracing_options,
                                 std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::eventarc::v1::Trigger> EventarcLogging::GetTrigger(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetTriggerRequest const& request) {
        return child_->GetTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListTriggersResponse>
EventarcLogging::ListTriggers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListTriggersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::ListTriggersRequest const& request) {
        return child_->ListTriggers(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncCreateTrigger(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
        return child_->AsyncCreateTrigger(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::CreateTrigger(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
        return child_->CreateTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncUpdateTrigger(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
        return child_->AsyncUpdateTrigger(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::UpdateTrigger(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
        return child_->UpdateTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncDeleteTrigger(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
        return child_->AsyncDeleteTrigger(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::DeleteTrigger(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
        return child_->DeleteTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::Channel> EventarcLogging::GetChannel(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetChannelRequest const& request) {
        return child_->GetChannel(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListChannelsResponse>
EventarcLogging::ListChannels(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListChannelsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::ListChannelsRequest const& request) {
        return child_->ListChannels(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncCreateChannel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::CreateChannelRequest const& request) {
        return child_->AsyncCreateChannel(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::CreateChannel(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateChannelRequest const& request) {
        return child_->CreateChannel(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncUpdateChannel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
        return child_->AsyncUpdateChannel(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::UpdateChannel(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
        return child_->UpdateChannel(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncDeleteChannel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
        return child_->AsyncDeleteChannel(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::DeleteChannel(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
        return child_->DeleteChannel(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::Provider> EventarcLogging::GetProvider(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetProviderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetProviderRequest const& request) {
        return child_->GetProvider(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListProvidersResponse>
EventarcLogging::ListProviders(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListProvidersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::ListProvidersRequest const& request) {
        return child_->ListProviders(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ChannelConnection>
EventarcLogging::GetChannelConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetChannelConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetChannelConnectionRequest const&
                 request) {
        return child_->GetChannelConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListChannelConnectionsResponse>
EventarcLogging::ListChannelConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListChannelConnectionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::ListChannelConnectionsRequest const&
                 request) {
        return child_->ListChannelConnections(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncCreateChannelConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
                 request) {
        return child_->AsyncCreateChannelConnection(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
EventarcLogging::CreateChannelConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
                 request) {
        return child_->CreateChannelConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncDeleteChannelConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
                 request) {
        return child_->AsyncDeleteChannelConnection(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
EventarcLogging::DeleteChannelConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
                 request) {
        return child_->DeleteChannelConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcLogging::GetGoogleChannelConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const&
                 request) {
        return child_->GetGoogleChannelConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcLogging::UpdateGoogleChannelConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
              request) {
        return child_->UpdateGoogleChannelConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::MessageBus>
EventarcLogging::GetMessageBus(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetMessageBusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetMessageBusRequest const& request) {
        return child_->GetMessageBus(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListMessageBusesResponse>
EventarcLogging::ListMessageBuses(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListMessageBusesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::ListMessageBusesRequest const& request) {
        return child_->ListMessageBuses(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListMessageBusEnrollmentsResponse>
EventarcLogging::ListMessageBusEnrollments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListMessageBusEnrollmentsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::ListMessageBusEnrollmentsRequest const&
              request) {
        return child_->ListMessageBusEnrollments(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncCreateMessageBus(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
        return child_->AsyncCreateMessageBus(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::CreateMessageBus(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
        return child_->CreateMessageBus(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncUpdateMessageBus(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
        return child_->AsyncUpdateMessageBus(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::UpdateMessageBus(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
        return child_->UpdateMessageBus(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncDeleteMessageBus(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
        return child_->AsyncDeleteMessageBus(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::DeleteMessageBus(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
        return child_->DeleteMessageBus(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::Enrollment>
EventarcLogging::GetEnrollment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetEnrollmentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetEnrollmentRequest const& request) {
        return child_->GetEnrollment(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListEnrollmentsResponse>
EventarcLogging::ListEnrollments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListEnrollmentsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::ListEnrollmentsRequest const& request) {
        return child_->ListEnrollments(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncCreateEnrollment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
        return child_->AsyncCreateEnrollment(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::CreateEnrollment(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
        return child_->CreateEnrollment(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncUpdateEnrollment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
        return child_->AsyncUpdateEnrollment(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::UpdateEnrollment(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
        return child_->UpdateEnrollment(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncDeleteEnrollment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
        return child_->AsyncDeleteEnrollment(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::DeleteEnrollment(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
        return child_->DeleteEnrollment(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::Pipeline> EventarcLogging::GetPipeline(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetPipelineRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetPipelineRequest const& request) {
        return child_->GetPipeline(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListPipelinesResponse>
EventarcLogging::ListPipelines(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListPipelinesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::ListPipelinesRequest const& request) {
        return child_->ListPipelines(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncCreatePipeline(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
        return child_->AsyncCreatePipeline(cq, std::move(context),
                                           std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::CreatePipeline(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
        return child_->CreatePipeline(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncUpdatePipeline(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
        return child_->AsyncUpdatePipeline(cq, std::move(context),
                                           std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::UpdatePipeline(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
        return child_->UpdatePipeline(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncDeletePipeline(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
        return child_->AsyncDeletePipeline(cq, std::move(context),
                                           std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::DeletePipeline(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
        return child_->DeletePipeline(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::GoogleApiSource>
EventarcLogging::GetGoogleApiSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::GetGoogleApiSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetGoogleApiSourceRequest const&
                 request) {
        return child_->GetGoogleApiSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::eventarc::v1::ListGoogleApiSourcesResponse>
EventarcLogging::ListGoogleApiSources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::eventarc::v1::ListGoogleApiSourcesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::ListGoogleApiSourcesRequest const&
                 request) {
        return child_->ListGoogleApiSources(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncCreateGoogleApiSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const&
                 request) {
        return child_->AsyncCreateGoogleApiSource(cq, std::move(context),
                                                  std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::CreateGoogleApiSource(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const&
                 request) {
        return child_->CreateGoogleApiSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncUpdateGoogleApiSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const&
                 request) {
        return child_->AsyncUpdateGoogleApiSource(cq, std::move(context),
                                                  std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::UpdateGoogleApiSource(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const&
                 request) {
        return child_->UpdateGoogleApiSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncDeleteGoogleApiSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const&
                 request) {
        return child_->AsyncDeleteGoogleApiSource(cq, std::move(context),
                                                  std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::DeleteGoogleApiSource(
    grpc::ClientContext& context, Options options,
    google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const&
                 request) {
        return child_->DeleteGoogleApiSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::ListLocationsResponse>
EventarcLogging::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::ListLocationsRequest const& request) {
        return child_->ListLocations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::Location> EventarcLogging::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return child_->GetLocation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> EventarcLogging::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> EventarcLogging::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
EventarcLogging::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::ListOperationsResponse>
EventarcLogging::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::ListOperationsRequest const& request) {
        return child_->ListOperations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::Operation> EventarcLogging::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->GetOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status EventarcLogging::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return child_->DeleteOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status EventarcLogging::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->CancelOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
EventarcLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> EventarcLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_v1_internal
}  // namespace cloud
}  // namespace google
