// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/v1/internal/eventarc_connection_impl.h"
#include "google/cloud/eventarc/v1/internal/eventarc_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace eventarc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<eventarc_v1::EventarcRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<eventarc_v1::EventarcRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<eventarc_v1::EventarcBackoffPolicyOption>()->clone();
}

std::unique_ptr<eventarc_v1::EventarcConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<eventarc_v1::EventarcConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<eventarc_v1::EventarcPollingPolicyOption>()->clone();
}

}  // namespace

EventarcConnectionImpl::EventarcConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<eventarc_v1_internal::EventarcStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      EventarcConnection::options())) {}

StatusOr<google::cloud::eventarc::v1::Trigger>
EventarcConnectionImpl::GetTrigger(
    google::cloud::eventarc::v1::GetTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetTriggerRequest const& request) {
        return stub_->GetTrigger(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Trigger>
EventarcConnectionImpl::ListTriggers(
    google::cloud::eventarc::v1::ListTriggersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTriggers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Trigger>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListTriggersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListTriggersRequest const&
                       request) {
              return stub->ListTriggers(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListTriggersResponse r) {
        std::vector<google::cloud::eventarc::v1::Trigger> result(
            r.triggers().size());
        auto& messages = *r.mutable_triggers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::CreateTrigger(
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateTrigger(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
        return stub->AsyncCreateTrigger(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::CreateTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
        return stub_->CreateTrigger(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::CreateTrigger(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Trigger>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateTrigger",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::UpdateTrigger(
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateTrigger(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
        return stub->AsyncUpdateTrigger(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::UpdateTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
        return stub_->UpdateTrigger(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::UpdateTrigger(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Trigger>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateTrigger",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::DeleteTrigger(
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteTrigger(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
        return stub->AsyncDeleteTrigger(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::DeleteTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
        return stub_->DeleteTrigger(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::DeleteTrigger(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Trigger>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteTrigger",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::Channel>
EventarcConnectionImpl::GetChannel(
    google::cloud::eventarc::v1::GetChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetChannelRequest const& request) {
        return stub_->GetChannel(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Channel>
EventarcConnectionImpl::ListChannels(
    google::cloud::eventarc::v1::ListChannelsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListChannels(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Channel>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListChannelsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListChannelsRequest const&
                       request) {
              return stub->ListChannels(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListChannelsResponse r) {
        std::vector<google::cloud::eventarc::v1::Channel> result(
            r.channels().size());
        auto& messages = *r.mutable_channels();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::CreateChannel(
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateChannel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateChannelRequest const& request) {
        return stub->AsyncCreateChannel(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::CreateChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateChannelRequest const& request) {
        return stub_->CreateChannel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::CreateChannel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Channel>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateChannel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::UpdateChannel(
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateChannel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
        return stub->AsyncUpdateChannel(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::UpdateChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
        return stub_->UpdateChannel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::UpdateChannel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Channel>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateChannel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::DeleteChannel(
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteChannel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
        return stub->AsyncDeleteChannel(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::DeleteChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
        return stub_->DeleteChannel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::DeleteChannel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Channel>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteChannel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::Provider>
EventarcConnectionImpl::GetProvider(
    google::cloud::eventarc::v1::GetProviderRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetProvider(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetProviderRequest const& request) {
        return stub_->GetProvider(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Provider>
EventarcConnectionImpl::ListProviders(
    google::cloud::eventarc::v1::ListProvidersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListProviders(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Provider>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListProvidersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListProvidersRequest const&
                       request) {
              return stub->ListProviders(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListProvidersResponse r) {
        std::vector<google::cloud::eventarc::v1::Provider> result(
            r.providers().size());
        auto& messages = *r.mutable_providers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::eventarc::v1::ChannelConnection>
EventarcConnectionImpl::GetChannelConnection(
    google::cloud::eventarc::v1::GetChannelConnectionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetChannelConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetChannelConnectionRequest const&
                 request) {
        return stub_->GetChannelConnection(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::ChannelConnection>
EventarcConnectionImpl::ListChannelConnections(
    google::cloud::eventarc::v1::ListChannelConnectionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListChannelConnections(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::ChannelConnection>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListChannelConnectionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::
                       ListChannelConnectionsRequest const& request) {
              return stub->ListChannelConnections(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListChannelConnectionsResponse r) {
        std::vector<google::cloud::eventarc::v1::ChannelConnection> result(
            r.channel_connections().size());
        auto& messages = *r.mutable_channel_connections();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::CreateChannelConnection(
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateChannelConnection(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
              request) {
        return stub->AsyncCreateChannelConnection(cq, std::move(context),
                                                  std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::CreateChannelConnection(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateChannelConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
                 request) {
        return stub_->CreateChannelConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::CreateChannelConnection(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::eventarc::v1::ChannelConnection>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateChannelConnection",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::DeleteChannelConnection(
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteChannelConnection(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
              request) {
        return stub->AsyncDeleteChannelConnection(cq, std::move(context),
                                                  std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::DeleteChannelConnection(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteChannelConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
                 request) {
        return stub_->DeleteChannelConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::DeleteChannelConnection(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::eventarc::v1::ChannelConnection>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteChannelConnection",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcConnectionImpl::GetGoogleChannelConfig(
    google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGoogleChannelConfig(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const&
                 request) {
        return stub_->GetGoogleChannelConfig(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcConnectionImpl::UpdateGoogleChannelConfig(
    google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGoogleChannelConfig(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
              request) {
        return stub_->UpdateGoogleChannelConfig(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::eventarc::v1::MessageBus>
EventarcConnectionImpl::GetMessageBus(
    google::cloud::eventarc::v1::GetMessageBusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMessageBus(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetMessageBusRequest const& request) {
        return stub_->GetMessageBus(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::MessageBus>
EventarcConnectionImpl::ListMessageBuses(
    google::cloud::eventarc::v1::ListMessageBusesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListMessageBuses(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::MessageBus>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListMessageBusesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListMessageBusesRequest const&
                       request) {
              return stub->ListMessageBuses(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListMessageBusesResponse r) {
        std::vector<google::cloud::eventarc::v1::MessageBus> result(
            r.message_buses().size());
        auto& messages = *r.mutable_message_buses();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::eventarc::v1::ListMessageBusEnrollmentsResponse>
EventarcConnectionImpl::ListMessageBusEnrollments(
    google::cloud::eventarc::v1::ListMessageBusEnrollmentsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListMessageBusEnrollments(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::ListMessageBusEnrollmentsRequest const&
              request) {
        return stub_->ListMessageBusEnrollments(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::MessageBus>>
EventarcConnectionImpl::CreateMessageBus(
    google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateMessageBus(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::MessageBus>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
        return stub->AsyncCreateMessageBus(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::MessageBus>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::CreateMessageBus(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateMessageBus(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::CreateMessageBusRequest const& request) {
        return stub_->CreateMessageBus(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::MessageBus>>
EventarcConnectionImpl::CreateMessageBus(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::MessageBus>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateMessageBus",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::MessageBus>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::MessageBus>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::MessageBus>>
EventarcConnectionImpl::UpdateMessageBus(
    google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateMessageBus(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::MessageBus>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
        return stub->AsyncUpdateMessageBus(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::MessageBus>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::UpdateMessageBus(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateMessageBus(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdateMessageBusRequest const& request) {
        return stub_->UpdateMessageBus(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::MessageBus>>
EventarcConnectionImpl::UpdateMessageBus(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::MessageBus>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateMessageBus",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::MessageBus>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::MessageBus>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::MessageBus>>
EventarcConnectionImpl::DeleteMessageBus(
    google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteMessageBus(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::MessageBus>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
        return stub->AsyncDeleteMessageBus(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::MessageBus>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::DeleteMessageBus(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteMessageBus(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::DeleteMessageBusRequest const& request) {
        return stub_->DeleteMessageBus(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::MessageBus>>
EventarcConnectionImpl::DeleteMessageBus(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::MessageBus>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteMessageBus",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::MessageBus>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::MessageBus>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::Enrollment>
EventarcConnectionImpl::GetEnrollment(
    google::cloud::eventarc::v1::GetEnrollmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEnrollment(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetEnrollmentRequest const& request) {
        return stub_->GetEnrollment(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Enrollment>
EventarcConnectionImpl::ListEnrollments(
    google::cloud::eventarc::v1::ListEnrollmentsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEnrollments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Enrollment>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListEnrollmentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListEnrollmentsRequest const&
                       request) {
              return stub->ListEnrollments(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListEnrollmentsResponse r) {
        std::vector<google::cloud::eventarc::v1::Enrollment> result(
            r.enrollments().size());
        auto& messages = *r.mutable_enrollments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::Enrollment>>
EventarcConnectionImpl::CreateEnrollment(
    google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateEnrollment(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Enrollment>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
        return stub->AsyncCreateEnrollment(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Enrollment>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::CreateEnrollment(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEnrollment(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::CreateEnrollmentRequest const& request) {
        return stub_->CreateEnrollment(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Enrollment>>
EventarcConnectionImpl::CreateEnrollment(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Enrollment>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateEnrollment",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Enrollment>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Enrollment>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Enrollment>>
EventarcConnectionImpl::UpdateEnrollment(
    google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateEnrollment(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Enrollment>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
        return stub->AsyncUpdateEnrollment(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Enrollment>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::UpdateEnrollment(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEnrollment(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request) {
        return stub_->UpdateEnrollment(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Enrollment>>
EventarcConnectionImpl::UpdateEnrollment(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Enrollment>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateEnrollment",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Enrollment>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Enrollment>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Enrollment>>
EventarcConnectionImpl::DeleteEnrollment(
    google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteEnrollment(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Enrollment>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
        return stub->AsyncDeleteEnrollment(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Enrollment>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::DeleteEnrollment(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEnrollment(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request) {
        return stub_->DeleteEnrollment(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Enrollment>>
EventarcConnectionImpl::DeleteEnrollment(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Enrollment>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteEnrollment",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Enrollment>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Enrollment>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::Pipeline>
EventarcConnectionImpl::GetPipeline(
    google::cloud::eventarc::v1::GetPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPipeline(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetPipelineRequest const& request) {
        return stub_->GetPipeline(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Pipeline>
EventarcConnectionImpl::ListPipelines(
    google::cloud::eventarc::v1::ListPipelinesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPipelines(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Pipeline>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListPipelinesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListPipelinesRequest const&
                       request) {
              return stub->ListPipelines(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListPipelinesResponse r) {
        std::vector<google::cloud::eventarc::v1::Pipeline> result(
            r.pipelines().size());
        auto& messages = *r.mutable_pipelines();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::Pipeline>>
EventarcConnectionImpl::CreatePipeline(
    google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreatePipeline(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Pipeline>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
        return stub->AsyncCreatePipeline(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Pipeline>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::CreatePipeline(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePipeline(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::CreatePipelineRequest const& request) {
        return stub_->CreatePipeline(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Pipeline>>
EventarcConnectionImpl::CreatePipeline(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Pipeline>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreatePipeline",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Pipeline>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Pipeline>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Pipeline>>
EventarcConnectionImpl::UpdatePipeline(
    google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdatePipeline(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Pipeline>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
        return stub->AsyncUpdatePipeline(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Pipeline>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::UpdatePipeline(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePipeline(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdatePipelineRequest const& request) {
        return stub_->UpdatePipeline(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Pipeline>>
EventarcConnectionImpl::UpdatePipeline(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Pipeline>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdatePipeline",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Pipeline>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Pipeline>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Pipeline>>
EventarcConnectionImpl::DeletePipeline(
    google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeletePipeline(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Pipeline>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
        return stub->AsyncDeletePipeline(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Pipeline>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::DeletePipeline(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePipeline(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::DeletePipelineRequest const& request) {
        return stub_->DeletePipeline(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Pipeline>>
EventarcConnectionImpl::DeletePipeline(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Pipeline>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeletePipeline",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Pipeline>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Pipeline>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::GoogleApiSource>
EventarcConnectionImpl::GetGoogleApiSource(
    google::cloud::eventarc::v1::GetGoogleApiSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGoogleApiSource(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetGoogleApiSourceRequest const&
                 request) {
        return stub_->GetGoogleApiSource(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::GoogleApiSource>
EventarcConnectionImpl::ListGoogleApiSources(
    google::cloud::eventarc::v1::ListGoogleApiSourcesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListGoogleApiSources(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::GoogleApiSource>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListGoogleApiSourcesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::eventarc::v1::ListGoogleApiSourcesRequest const&
                    request) {
              return stub->ListGoogleApiSources(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListGoogleApiSourcesResponse r) {
        std::vector<google::cloud::eventarc::v1::GoogleApiSource> result(
            r.google_api_sources().size());
        auto& messages = *r.mutable_google_api_sources();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
EventarcConnectionImpl::CreateGoogleApiSource(
    google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateGoogleApiSource(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::GoogleApiSource>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const&
              request) {
        return stub->AsyncCreateGoogleApiSource(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::GoogleApiSource>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::CreateGoogleApiSource(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGoogleApiSource(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const&
                 request) {
        return stub_->CreateGoogleApiSource(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
EventarcConnectionImpl::CreateGoogleApiSource(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateGoogleApiSource",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::GoogleApiSource>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::GoogleApiSource>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
EventarcConnectionImpl::UpdateGoogleApiSource(
    google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateGoogleApiSource(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::GoogleApiSource>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const&
              request) {
        return stub->AsyncUpdateGoogleApiSource(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::GoogleApiSource>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::UpdateGoogleApiSource(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGoogleApiSource(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const&
                 request) {
        return stub_->UpdateGoogleApiSource(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
EventarcConnectionImpl::UpdateGoogleApiSource(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateGoogleApiSource",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::GoogleApiSource>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::GoogleApiSource>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
EventarcConnectionImpl::DeleteGoogleApiSource(
    google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteGoogleApiSource(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::GoogleApiSource>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const&
              request) {
        return stub->AsyncDeleteGoogleApiSource(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::GoogleApiSource>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::DeleteGoogleApiSource(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteGoogleApiSource(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const&
                 request) {
        return stub_->DeleteGoogleApiSource(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
EventarcConnectionImpl::DeleteGoogleApiSource(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteGoogleApiSource",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::GoogleApiSource>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::GoogleApiSource>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::location::Location>
EventarcConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location> EventarcConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> EventarcConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> EventarcConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
EventarcConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
EventarcConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status EventarcConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

Status EventarcConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_v1_internal
}  // namespace cloud
}  // namespace google
