// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_V1_EVENTARC_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_V1_EVENTARC_CLIENT_H

#include "google/cloud/eventarc/v1/eventarc_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace eventarc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Eventarc allows users to subscribe to various events that are provided by
/// Google Cloud services and forward them to supported destinations.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class EventarcClient {
 public:
  explicit EventarcClient(std::shared_ptr<EventarcConnection> connection,
                          Options opts = {});
  ~EventarcClient();

  ///@{
  /// @name Copy and move support
  EventarcClient(EventarcClient const&) = default;
  EventarcClient& operator=(EventarcClient const&) = default;
  EventarcClient(EventarcClient&&) = default;
  EventarcClient& operator=(EventarcClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(EventarcClient const& a, EventarcClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(EventarcClient const& a, EventarcClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Get a single trigger.
  ///
  /// @param name  Required. The name of the trigger to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Trigger])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L489}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Trigger> GetTrigger(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single trigger.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetTriggerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Trigger])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L489}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Trigger> GetTrigger(
      google::cloud::eventarc::v1::GetTriggerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List triggers.
  ///
  /// @param parent  Required. The parent collection to list triggers on.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Trigger], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListTriggersRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L500}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Trigger> ListTriggers(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List triggers.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListTriggersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Trigger], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListTriggersRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L500}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Trigger> ListTriggers(
      google::cloud::eventarc::v1::ListTriggersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new trigger in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this trigger.
  /// @param trigger  Required. The trigger to create.
  /// @param trigger_id  Required. The user-provided ID to be assigned to the trigger.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Trigger] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L547}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> CreateTrigger(
      std::string const& parent,
      google::cloud::eventarc::v1::Trigger const& trigger,
      std::string const& trigger_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTrigger
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTrigger(
      NoAwaitTag, std::string const& parent,
      google::cloud::eventarc::v1::Trigger const& trigger,
      std::string const& trigger_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new trigger in a particular project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.CreateTriggerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Trigger] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L547}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> CreateTrigger(
      google::cloud::eventarc::v1::CreateTriggerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTrigger
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTrigger(
      NoAwaitTag,
      google::cloud::eventarc::v1::CreateTriggerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTrigger
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> CreateTrigger(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Update a single trigger.
  ///
  /// @param trigger  The trigger to be updated.
  /// @param update_mask  The fields to be updated; only fields explicitly provided are updated.
  ///  If no field mask is provided, all provided fields in the request are
  ///  updated. To update all fields, provide a field mask of "*".
  /// @param allow_missing  If set to true, and the trigger is not found, a new trigger will be
  ///  created. In this situation, `update_mask` is ignored.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Trigger] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  /// [google.cloud.eventarc.v1.UpdateTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L568}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> UpdateTrigger(
      google::cloud::eventarc::v1::Trigger const& trigger,
      google::protobuf::FieldMask const& update_mask, bool allow_missing,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTrigger
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTrigger(
      NoAwaitTag, google::cloud::eventarc::v1::Trigger const& trigger,
      google::protobuf::FieldMask const& update_mask, bool allow_missing,
      Options opts = {});

  // clang-format off
  ///
  /// Update a single trigger.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.UpdateTriggerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Trigger] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  /// [google.cloud.eventarc.v1.UpdateTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L568}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> UpdateTrigger(
      google::cloud::eventarc::v1::UpdateTriggerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTrigger
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTrigger(
      NoAwaitTag,
      google::cloud::eventarc::v1::UpdateTriggerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTrigger
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> UpdateTrigger(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Delete a single trigger.
  ///
  /// @param name  Required. The name of the trigger to be deleted.
  /// @param allow_missing  If set to true, and the trigger is not found, the request will succeed
  ///  but no action will be taken on the server.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Trigger] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L587}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> DeleteTrigger(
      std::string const& name, bool allow_missing, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTrigger
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTrigger(
      NoAwaitTag, std::string const& name, bool allow_missing,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a single trigger.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.DeleteTriggerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Trigger] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteTriggerRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L587}
  /// [google.cloud.eventarc.v1.Trigger]: @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> DeleteTrigger(
      google::cloud::eventarc::v1::DeleteTriggerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTrigger
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTrigger(
      NoAwaitTag,
      google::cloud::eventarc::v1::DeleteTriggerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTrigger
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> DeleteTrigger(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Get a single Channel.
  ///
  /// @param name  Required. The name of the channel to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Channel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.GetChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L610}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Channel> GetChannel(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single Channel.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Channel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.GetChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L610}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Channel> GetChannel(
      google::cloud::eventarc::v1::GetChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List channels.
  ///
  /// @param parent  Required. The parent collection to list channels on.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Channel], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.ListChannelsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L621}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Channel> ListChannels(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List channels.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListChannelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Channel], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.ListChannelsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L621}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Channel> ListChannels(
      google::cloud::eventarc::v1::ListChannelsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new channel in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this channel.
  /// @param channel  Required. The channel to create.
  /// @param channel_id  Required. The user-provided ID to be assigned to the channel.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Channel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.CreateChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L663}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> CreateChannel(
      std::string const& parent,
      google::cloud::eventarc::v1::Channel const& channel,
      std::string const& channel_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateChannel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateChannel(
      NoAwaitTag, std::string const& parent,
      google::cloud::eventarc::v1::Channel const& channel,
      std::string const& channel_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new channel in a particular project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.CreateChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Channel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.CreateChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L663}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> CreateChannel(
      google::cloud::eventarc::v1::CreateChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateChannel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateChannel(
      NoAwaitTag,
      google::cloud::eventarc::v1::CreateChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateChannel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> CreateChannel(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Update a single channel.
  ///
  /// @param channel  The channel to be updated.
  /// @param update_mask  The fields to be updated; only fields explicitly provided are updated.
  ///  If no field mask is provided, all provided fields in the request are
  ///  updated. To update all fields, provide a field mask of "*".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Channel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.UpdateChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L684}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> UpdateChannel(
      google::cloud::eventarc::v1::Channel const& channel,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateChannel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateChannel(
      NoAwaitTag, google::cloud::eventarc::v1::Channel const& channel,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a single channel.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.UpdateChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Channel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.UpdateChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L684}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> UpdateChannel(
      google::cloud::eventarc::v1::UpdateChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateChannel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateChannel(
      NoAwaitTag,
      google::cloud::eventarc::v1::UpdateChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateChannel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> UpdateChannel(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Delete a single channel.
  ///
  /// @param name  Required. The name of the channel to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Channel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.DeleteChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L699}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> DeleteChannel(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteChannel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteChannel(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete a single channel.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.DeleteChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Channel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Channel]: @googleapis_reference_link{google/cloud/eventarc/v1/channel.proto#L35}
  /// [google.cloud.eventarc.v1.DeleteChannelRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L699}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> DeleteChannel(
      google::cloud::eventarc::v1::DeleteChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteChannel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteChannel(
      NoAwaitTag,
      google::cloud::eventarc::v1::DeleteChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteChannel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Channel>> DeleteChannel(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Get a single Provider.
  ///
  /// @param name  Required. The name of the provider to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Provider])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetProviderRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L714}
  /// [google.cloud.eventarc.v1.Provider]: @googleapis_reference_link{google/cloud/eventarc/v1/discovery.proto#L28}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Provider> GetProvider(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single Provider.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetProviderRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Provider])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetProviderRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L714}
  /// [google.cloud.eventarc.v1.Provider]: @googleapis_reference_link{google/cloud/eventarc/v1/discovery.proto#L28}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Provider> GetProvider(
      google::cloud::eventarc::v1::GetProviderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List providers.
  ///
  /// @param parent  Required. The parent of the provider to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Provider], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListProvidersRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L725}
  /// [google.cloud.eventarc.v1.Provider]: @googleapis_reference_link{google/cloud/eventarc/v1/discovery.proto#L28}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Provider> ListProviders(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List providers.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListProvidersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Provider], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListProvidersRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L725}
  /// [google.cloud.eventarc.v1.Provider]: @googleapis_reference_link{google/cloud/eventarc/v1/discovery.proto#L28}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Provider> ListProviders(
      google::cloud::eventarc::v1::ListProvidersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Get a single ChannelConnection.
  ///
  /// @param name  Required. The name of the channel connection to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.ChannelConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.GetChannelConnectionRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L768}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::ChannelConnection> GetChannelConnection(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single ChannelConnection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetChannelConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.ChannelConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.GetChannelConnectionRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L768}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::ChannelConnection> GetChannelConnection(
      google::cloud::eventarc::v1::GetChannelConnectionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List channel connections.
  ///
  /// @param parent  Required. The parent collection from which to list channel connections.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.ChannelConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.ListChannelConnectionsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L779}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::ChannelConnection>
  ListChannelConnections(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List channel connections.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListChannelConnectionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.ChannelConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.ListChannelConnectionsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L779}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::ChannelConnection>
  ListChannelConnections(
      google::cloud::eventarc::v1::ListChannelConnectionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new ChannelConnection in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this channel connection.
  /// @param channel_connection  Required. Channel connection to create.
  /// @param channel_connection_id  Required. The user-provided ID to be assigned to the channel connection.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.ChannelConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.CreateChannelConnectionRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L817}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
  CreateChannelConnection(
      std::string const& parent,
      google::cloud::eventarc::v1::ChannelConnection const& channel_connection,
      std::string const& channel_connection_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateChannelConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateChannelConnection(
      NoAwaitTag, std::string const& parent,
      google::cloud::eventarc::v1::ChannelConnection const& channel_connection,
      std::string const& channel_connection_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new ChannelConnection in a particular project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.CreateChannelConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.ChannelConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.CreateChannelConnectionRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L817}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
  CreateChannelConnection(
      google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateChannelConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateChannelConnection(
      NoAwaitTag,
      google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateChannelConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
  CreateChannelConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Delete a single ChannelConnection.
  ///
  /// @param name  Required. The name of the channel connection to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.ChannelConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.DeleteChannelConnectionRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L835}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
  DeleteChannelConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteChannelConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteChannelConnection(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete a single ChannelConnection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.DeleteChannelConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.ChannelConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ChannelConnection]: @googleapis_reference_link{google/cloud/eventarc/v1/channel_connection.proto#L35}
  /// [google.cloud.eventarc.v1.DeleteChannelConnectionRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L835}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
  DeleteChannelConnection(
      google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteChannelConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteChannelConnection(
      NoAwaitTag,
      google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteChannelConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
  DeleteChannelConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Get a GoogleChannelConfig
  ///
  /// @param name  Required. The name of the config to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.GoogleChannelConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetGoogleChannelConfigRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L858}
  /// [google.cloud.eventarc.v1.GoogleChannelConfig]: @googleapis_reference_link{google/cloud/eventarc/v1/google_channel_config.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
  GetGoogleChannelConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a GoogleChannelConfig
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetGoogleChannelConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.GoogleChannelConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetGoogleChannelConfigRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L858}
  /// [google.cloud.eventarc.v1.GoogleChannelConfig]: @googleapis_reference_link{google/cloud/eventarc/v1/google_channel_config.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
  GetGoogleChannelConfig(
      google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a single GoogleChannelConfig
  ///
  /// @param google_channel_config  Required. The config to be updated.
  /// @param update_mask  The fields to be updated; only fields explicitly provided are updated.
  ///  If no field mask is provided, all provided fields in the request are
  ///  updated. To update all fields, provide a field mask of "*".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.GoogleChannelConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GoogleChannelConfig]: @googleapis_reference_link{google/cloud/eventarc/v1/google_channel_config.proto#L40}
  /// [google.cloud.eventarc.v1.UpdateGoogleChannelConfigRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L846}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
  UpdateGoogleChannelConfig(
      google::cloud::eventarc::v1::GoogleChannelConfig const&
          google_channel_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a single GoogleChannelConfig
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.UpdateGoogleChannelConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.GoogleChannelConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GoogleChannelConfig]: @googleapis_reference_link{google/cloud/eventarc/v1/google_channel_config.proto#L40}
  /// [google.cloud.eventarc.v1.UpdateGoogleChannelConfigRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L846}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
  UpdateGoogleChannelConfig(
      google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Get a single MessageBus.
  ///
  /// @param name  Required. The name of the message bus to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.MessageBus])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L869}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::MessageBus> GetMessageBus(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single MessageBus.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetMessageBusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.MessageBus])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L869}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::MessageBus> GetMessageBus(
      google::cloud::eventarc::v1::GetMessageBusRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List message buses.
  ///
  /// @param parent  Required. The parent collection to list triggers on.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.MessageBus], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListMessageBusesRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L880}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::MessageBus> ListMessageBuses(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List message buses.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListMessageBusesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.MessageBus], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListMessageBusesRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L880}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::MessageBus> ListMessageBuses(
      google::cloud::eventarc::v1::ListMessageBusesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// List message bus enrollments.
  ///
  /// @param parent  Required. The parent message bus to list enrollments on.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.ListMessageBusEnrollmentsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListMessageBusEnrollmentsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L926}
  /// [google.cloud.eventarc.v1.ListMessageBusEnrollmentsResponse]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L949}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::ListMessageBusEnrollmentsResponse>
  ListMessageBusEnrollments(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List message bus enrollments.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListMessageBusEnrollmentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.ListMessageBusEnrollmentsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListMessageBusEnrollmentsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L926}
  /// [google.cloud.eventarc.v1.ListMessageBusEnrollmentsResponse]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L949}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::ListMessageBusEnrollmentsResponse>
  ListMessageBusEnrollments(
      google::cloud::eventarc::v1::ListMessageBusEnrollmentsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new MessageBus in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this message bus.
  /// @param message_bus  Required. The message bus to create.
  /// @param message_bus_id  Required. The user-provided ID to be assigned to the MessageBus. It should
  ///  match the format (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.MessageBus] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L962}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> CreateMessageBus(
      std::string const& parent,
      google::cloud::eventarc::v1::MessageBus const& message_bus,
      std::string const& message_bus_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMessageBus
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMessageBus(
      NoAwaitTag, std::string const& parent,
      google::cloud::eventarc::v1::MessageBus const& message_bus,
      std::string const& message_bus_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new MessageBus in a particular project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.CreateMessageBusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.MessageBus] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L962}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> CreateMessageBus(
      google::cloud::eventarc::v1::CreateMessageBusRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMessageBus
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMessageBus(
      NoAwaitTag,
      google::cloud::eventarc::v1::CreateMessageBusRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMessageBus
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> CreateMessageBus(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Update a single message bus.
  ///
  /// @param message_bus  Required. The MessageBus to be updated.
  /// @param update_mask  Optional. The fields to be updated; only fields explicitly provided are
  ///  updated. If no field mask is provided, all provided fields in the request
  ///  are updated. To update all fields, provide a field mask of "*".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.MessageBus] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  /// [google.cloud.eventarc.v1.UpdateMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L984}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> UpdateMessageBus(
      google::cloud::eventarc::v1::MessageBus const& message_bus,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMessageBus
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMessageBus(
      NoAwaitTag, google::cloud::eventarc::v1::MessageBus const& message_bus,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a single message bus.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.UpdateMessageBusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.MessageBus] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  /// [google.cloud.eventarc.v1.UpdateMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L984}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> UpdateMessageBus(
      google::cloud::eventarc::v1::UpdateMessageBusRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMessageBus
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMessageBus(
      NoAwaitTag,
      google::cloud::eventarc::v1::UpdateMessageBusRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMessageBus
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> UpdateMessageBus(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Delete a single message bus.
  ///
  /// @param name  Required. The name of the MessageBus to be deleted.
  /// @param etag  Optional. If provided, the MessageBus will only be deleted if the etag
  ///  matches the current etag on the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.MessageBus] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1004}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> DeleteMessageBus(
      std::string const& name, std::string const& etag, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMessageBus
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMessageBus(
      NoAwaitTag, std::string const& name, std::string const& etag,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a single message bus.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.DeleteMessageBusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.MessageBus] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteMessageBusRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1004}
  /// [google.cloud.eventarc.v1.MessageBus]: @googleapis_reference_link{google/cloud/eventarc/v1/message_bus.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> DeleteMessageBus(
      google::cloud::eventarc::v1::DeleteMessageBusRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMessageBus
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMessageBus(
      NoAwaitTag,
      google::cloud::eventarc::v1::DeleteMessageBusRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMessageBus
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::MessageBus>> DeleteMessageBus(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Get a single Enrollment.
  ///
  /// @param name  Required. The name of the Enrollment to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Enrollment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  /// [google.cloud.eventarc.v1.GetEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1027}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Enrollment> GetEnrollment(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single Enrollment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetEnrollmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Enrollment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  /// [google.cloud.eventarc.v1.GetEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1027}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Enrollment> GetEnrollment(
      google::cloud::eventarc::v1::GetEnrollmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List Enrollments.
  ///
  /// @param parent  Required. The parent collection to list triggers on.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Enrollment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  /// [google.cloud.eventarc.v1.ListEnrollmentsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1038}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Enrollment> ListEnrollments(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List Enrollments.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListEnrollmentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Enrollment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  /// [google.cloud.eventarc.v1.ListEnrollmentsRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1038}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Enrollment> ListEnrollments(
      google::cloud::eventarc::v1::ListEnrollmentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new Enrollment in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this enrollment.
  /// @param enrollment  Required. The enrollment to create.
  /// @param enrollment_id  Required. The user-provided ID to be assigned to the Enrollment. It should
  ///  match the format (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Enrollment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1084}
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> CreateEnrollment(
      std::string const& parent,
      google::cloud::eventarc::v1::Enrollment const& enrollment,
      std::string const& enrollment_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEnrollment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEnrollment(
      NoAwaitTag, std::string const& parent,
      google::cloud::eventarc::v1::Enrollment const& enrollment,
      std::string const& enrollment_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new Enrollment in a particular project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.CreateEnrollmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Enrollment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1084}
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> CreateEnrollment(
      google::cloud::eventarc::v1::CreateEnrollmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEnrollment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEnrollment(
      NoAwaitTag,
      google::cloud::eventarc::v1::CreateEnrollmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEnrollment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> CreateEnrollment(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Update a single Enrollment.
  ///
  /// @param enrollment  Required. The Enrollment to be updated.
  /// @param update_mask  Optional. The fields to be updated; only fields explicitly provided are
  ///  updated. If no field mask is provided, all provided fields in the request
  ///  are updated. To update all fields, provide a field mask of "*".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Enrollment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  /// [google.cloud.eventarc.v1.UpdateEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1106}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> UpdateEnrollment(
      google::cloud::eventarc::v1::Enrollment const& enrollment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEnrollment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEnrollment(
      NoAwaitTag, google::cloud::eventarc::v1::Enrollment const& enrollment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a single Enrollment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.UpdateEnrollmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Enrollment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  /// [google.cloud.eventarc.v1.UpdateEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1106}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> UpdateEnrollment(
      google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEnrollment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEnrollment(
      NoAwaitTag,
      google::cloud::eventarc::v1::UpdateEnrollmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEnrollment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> UpdateEnrollment(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Delete a single Enrollment.
  ///
  /// @param name  Required. The name of the Enrollment to be deleted.
  /// @param etag  Optional. If provided, the Enrollment will only be deleted if the etag
  ///  matches the current etag on the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Enrollment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1126}
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> DeleteEnrollment(
      std::string const& name, std::string const& etag, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEnrollment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEnrollment(
      NoAwaitTag, std::string const& name, std::string const& etag,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a single Enrollment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.DeleteEnrollmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Enrollment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteEnrollmentRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1126}
  /// [google.cloud.eventarc.v1.Enrollment]: @googleapis_reference_link{google/cloud/eventarc/v1/enrollment.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> DeleteEnrollment(
      google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEnrollment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEnrollment(
      NoAwaitTag,
      google::cloud::eventarc::v1::DeleteEnrollmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEnrollment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Enrollment>> DeleteEnrollment(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Get a single Pipeline.
  ///
  /// @param name  Required. The name of the pipeline to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Pipeline])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetPipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1149}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Pipeline> GetPipeline(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single Pipeline.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetPipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.Pipeline])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetPipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1149}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::Pipeline> GetPipeline(
      google::cloud::eventarc::v1::GetPipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List pipelines.
  ///
  /// @param parent  Required. The parent collection to list pipelines on.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Pipeline], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListPipelinesRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1160}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Pipeline> ListPipelines(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List pipelines.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListPipelinesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.Pipeline], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.ListPipelinesRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1160}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::Pipeline> ListPipelines(
      google::cloud::eventarc::v1::ListPipelinesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new Pipeline in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this pipeline.
  /// @param pipeline  Required. The pipeline to create.
  /// @param pipeline_id  Required. The user-provided ID to be assigned to the Pipeline.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Pipeline] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreatePipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1206}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> CreatePipeline(
      std::string const& parent,
      google::cloud::eventarc::v1::Pipeline const& pipeline,
      std::string const& pipeline_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePipeline
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePipeline(
      NoAwaitTag, std::string const& parent,
      google::cloud::eventarc::v1::Pipeline const& pipeline,
      std::string const& pipeline_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new Pipeline in a particular project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.CreatePipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Pipeline] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreatePipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1206}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> CreatePipeline(
      google::cloud::eventarc::v1::CreatePipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePipeline
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePipeline(
      NoAwaitTag,
      google::cloud::eventarc::v1::CreatePipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePipeline
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> CreatePipeline(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Update a single pipeline.
  ///
  /// @param pipeline  Required. The Pipeline to be updated.
  /// @param update_mask  Optional. The fields to be updated; only fields explicitly provided are
  ///  updated. If no field mask is provided, all provided fields in the request
  ///  are updated. To update all fields, provide a field mask of "*".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Pipeline] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  /// [google.cloud.eventarc.v1.UpdatePipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1227}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> UpdatePipeline(
      google::cloud::eventarc::v1::Pipeline const& pipeline,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePipeline
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePipeline(
      NoAwaitTag, google::cloud::eventarc::v1::Pipeline const& pipeline,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a single pipeline.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.UpdatePipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Pipeline] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  /// [google.cloud.eventarc.v1.UpdatePipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1227}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> UpdatePipeline(
      google::cloud::eventarc::v1::UpdatePipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePipeline
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePipeline(
      NoAwaitTag,
      google::cloud::eventarc::v1::UpdatePipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePipeline
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> UpdatePipeline(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Delete a single pipeline.
  ///
  /// @param name  Required. The name of the Pipeline to be deleted.
  /// @param etag  Optional. If provided, the Pipeline will only be deleted if the etag
  ///  matches the current etag on the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Pipeline] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeletePipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1247}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> DeletePipeline(
      std::string const& name, std::string const& etag, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePipeline
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePipeline(
      NoAwaitTag, std::string const& name, std::string const& etag,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a single pipeline.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.DeletePipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.Pipeline] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeletePipelineRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1247}
  /// [google.cloud.eventarc.v1.Pipeline]: @googleapis_reference_link{google/cloud/eventarc/v1/pipeline.proto#L39}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> DeletePipeline(
      google::cloud::eventarc::v1::DeletePipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePipeline
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePipeline(
      NoAwaitTag,
      google::cloud::eventarc::v1::DeletePipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePipeline
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::Pipeline>> DeletePipeline(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Get a single GoogleApiSource.
  ///
  /// @param name  Required. The name of the google api source to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.GoogleApiSource])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1270}
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::GoogleApiSource> GetGoogleApiSource(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a single GoogleApiSource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.GetGoogleApiSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.eventarc.v1.GoogleApiSource])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GetGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1270}
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::eventarc::v1::GoogleApiSource> GetGoogleApiSource(
      google::cloud::eventarc::v1::GetGoogleApiSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List GoogleApiSources.
  ///
  /// @param parent  Required. The parent collection to list GoogleApiSources on.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.GoogleApiSource], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  /// [google.cloud.eventarc.v1.ListGoogleApiSourcesRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1281}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::GoogleApiSource>
  ListGoogleApiSources(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List GoogleApiSources.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.ListGoogleApiSourcesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.eventarc.v1.GoogleApiSource], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  /// [google.cloud.eventarc.v1.ListGoogleApiSourcesRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1281}
  ///
  // clang-format on
  StreamRange<google::cloud::eventarc::v1::GoogleApiSource>
  ListGoogleApiSources(
      google::cloud::eventarc::v1::ListGoogleApiSourcesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new GoogleApiSource in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this google api source.
  /// @param google_api_source  Required. The google api source to create.
  /// @param google_api_source_id  Required. The user-provided ID to be assigned to the GoogleApiSource. It
  ///  should match the format (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.GoogleApiSource] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1327}
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  CreateGoogleApiSource(
      std::string const& parent,
      google::cloud::eventarc::v1::GoogleApiSource const& google_api_source,
      std::string const& google_api_source_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGoogleApiSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGoogleApiSource(
      NoAwaitTag, std::string const& parent,
      google::cloud::eventarc::v1::GoogleApiSource const& google_api_source,
      std::string const& google_api_source_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new GoogleApiSource in a particular project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.CreateGoogleApiSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.GoogleApiSource] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.CreateGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1327}
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  CreateGoogleApiSource(
      google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGoogleApiSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGoogleApiSource(
      NoAwaitTag,
      google::cloud::eventarc::v1::CreateGoogleApiSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGoogleApiSource
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  CreateGoogleApiSource(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Update a single GoogleApiSource.
  ///
  /// @param google_api_source  Required. The GoogleApiSource to be updated.
  /// @param update_mask  Optional. The fields to be updated; only fields explicitly provided are
  ///  updated. If no field mask is provided, all provided fields in the request
  ///  are updated. To update all fields, provide a field mask of "*".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.GoogleApiSource] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  /// [google.cloud.eventarc.v1.UpdateGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1350}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  UpdateGoogleApiSource(
      google::cloud::eventarc::v1::GoogleApiSource const& google_api_source,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGoogleApiSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGoogleApiSource(
      NoAwaitTag,
      google::cloud::eventarc::v1::GoogleApiSource const& google_api_source,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a single GoogleApiSource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.UpdateGoogleApiSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.GoogleApiSource] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  /// [google.cloud.eventarc.v1.UpdateGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1350}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  UpdateGoogleApiSource(
      google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGoogleApiSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGoogleApiSource(
      NoAwaitTag,
      google::cloud::eventarc::v1::UpdateGoogleApiSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGoogleApiSource
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  UpdateGoogleApiSource(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Delete a single GoogleApiSource.
  ///
  /// @param name  Required. The name of the GoogleApiSource to be deleted.
  /// @param etag  Optional. If provided, the MessageBus will only be deleted if the etag
  ///  matches the current etag on the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.GoogleApiSource] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1372}
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  DeleteGoogleApiSource(std::string const& name, std::string const& etag,
                        Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGoogleApiSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGoogleApiSource(
      NoAwaitTag, std::string const& name, std::string const& etag,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a single GoogleApiSource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.eventarc.v1.DeleteGoogleApiSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.eventarc.v1.GoogleApiSource] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.eventarc.v1.DeleteGoogleApiSourceRequest]: @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L1372}
  /// [google.cloud.eventarc.v1.GoogleApiSource]: @googleapis_reference_link{google/cloud/eventarc/v1/google_api_source.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  DeleteGoogleApiSource(
      google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGoogleApiSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGoogleApiSource(
      NoAwaitTag,
      google::cloud::eventarc::v1::DeleteGoogleApiSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGoogleApiSource
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::eventarc::v1::GoogleApiSource>>
  DeleteGoogleApiSource(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Lists information about the supported locations for this service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.ListLocationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.location.Location], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.ListLocationsRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L58}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets information about a location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.GetLocationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.location.Location])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.GetLocationRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L82}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.SetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L100}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Gets the access control policy for a resource.
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.GetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Returns permissions that a caller has on the specified resource.
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a `NOT_FOUND` error.
  ///
  /// Note: This operation is designed to be used for building permission-aware
  /// UIs and command-line tools, not for authorization checking. This operation
  /// may "fail open" without warning.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.TestIamPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L137}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L153}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param name  The name of the operation resource to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.DeleteOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param name  The name of the operation resource to be cancelled.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.CancelOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<EventarcConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_V1_EVENTARC_CLIENT_H
