// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#include "google/cloud/edgenetwork/v1/internal/edge_network_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/edgenetwork/v1/service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace edgenetwork_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EdgeNetworkStub::~EdgeNetworkStub() = default;

StatusOr<google::cloud::edgenetwork::v1::InitializeZoneResponse>
DefaultEdgeNetworkStub::InitializeZone(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::InitializeZoneRequest const& request) {
  google::cloud::edgenetwork::v1::InitializeZoneResponse response;
  auto status = grpc_stub_->InitializeZone(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::ListZonesResponse>
DefaultEdgeNetworkStub::ListZones(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::ListZonesRequest const& request) {
  google::cloud::edgenetwork::v1::ListZonesResponse response;
  auto status = grpc_stub_->ListZones(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::Zone> DefaultEdgeNetworkStub::GetZone(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::GetZoneRequest const& request) {
  google::cloud::edgenetwork::v1::Zone response;
  auto status = grpc_stub_->GetZone(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::ListNetworksResponse>
DefaultEdgeNetworkStub::ListNetworks(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::ListNetworksRequest const& request) {
  google::cloud::edgenetwork::v1::ListNetworksResponse response;
  auto status = grpc_stub_->ListNetworks(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::Network>
DefaultEdgeNetworkStub::GetNetwork(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::GetNetworkRequest const& request) {
  google::cloud::edgenetwork::v1::Network response;
  auto status = grpc_stub_->GetNetwork(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseNetworkResponse>
DefaultEdgeNetworkStub::DiagnoseNetwork(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const& request) {
  google::cloud::edgenetwork::v1::DiagnoseNetworkResponse response;
  auto status = grpc_stub_->DiagnoseNetwork(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncCreateNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::CreateNetworkRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::CreateNetworkRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::edgenetwork::v1::CreateNetworkRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateNetwork(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::CreateNetwork(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::CreateNetworkRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateNetwork(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncDeleteNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::DeleteNetworkRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteNetwork(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::DeleteNetwork(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteNetwork(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::ListSubnetsResponse>
DefaultEdgeNetworkStub::ListSubnets(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::ListSubnetsRequest const& request) {
  google::cloud::edgenetwork::v1::ListSubnetsResponse response;
  auto status = grpc_stub_->ListSubnets(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::Subnet>
DefaultEdgeNetworkStub::GetSubnet(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::GetSubnetRequest const& request) {
  google::cloud::edgenetwork::v1::Subnet response;
  auto status = grpc_stub_->GetSubnet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncCreateSubnet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::CreateSubnetRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::CreateSubnetRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::CreateSubnetRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateSubnet(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::CreateSubnet(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::CreateSubnetRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateSubnet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncUpdateSubnet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::UpdateSubnetRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateSubnet(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::UpdateSubnet(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateSubnet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncDeleteSubnet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::DeleteSubnetRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteSubnet(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::DeleteSubnet(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteSubnet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::ListInterconnectsResponse>
DefaultEdgeNetworkStub::ListInterconnects(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::ListInterconnectsRequest const& request) {
  google::cloud::edgenetwork::v1::ListInterconnectsResponse response;
  auto status = grpc_stub_->ListInterconnects(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::Interconnect>
DefaultEdgeNetworkStub::GetInterconnect(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::GetInterconnectRequest const& request) {
  google::cloud::edgenetwork::v1::Interconnect response;
  auto status = grpc_stub_->GetInterconnect(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseInterconnectResponse>
DefaultEdgeNetworkStub::DiagnoseInterconnect(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&
        request) {
  google::cloud::edgenetwork::v1::DiagnoseInterconnectResponse response;
  auto status = grpc_stub_->DiagnoseInterconnect(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::ListInterconnectAttachmentsResponse>
DefaultEdgeNetworkStub::ListInterconnectAttachments(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::ListInterconnectAttachmentsRequest const&
        request) {
  google::cloud::edgenetwork::v1::ListInterconnectAttachmentsResponse response;
  auto status =
      grpc_stub_->ListInterconnectAttachments(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>
DefaultEdgeNetworkStub::GetInterconnectAttachment(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&
        request) {
  google::cloud::edgenetwork::v1::InterconnectAttachment response;
  auto status =
      grpc_stub_->GetInterconnectAttachment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncCreateInterconnectAttachment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::
                 CreateInterconnectAttachmentRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateInterconnectAttachment(context, request,
                                                             cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultEdgeNetworkStub::CreateInterconnectAttachment(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->CreateInterconnectAttachment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncDeleteInterconnectAttachment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::
                 DeleteInterconnectAttachmentRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteInterconnectAttachment(context, request,
                                                             cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultEdgeNetworkStub::DeleteInterconnectAttachment(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->DeleteInterconnectAttachment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::ListRoutersResponse>
DefaultEdgeNetworkStub::ListRouters(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::ListRoutersRequest const& request) {
  google::cloud::edgenetwork::v1::ListRoutersResponse response;
  auto status = grpc_stub_->ListRouters(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::Router>
DefaultEdgeNetworkStub::GetRouter(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::GetRouterRequest const& request) {
  google::cloud::edgenetwork::v1::Router response;
  auto status = grpc_stub_->GetRouter(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseRouterResponse>
DefaultEdgeNetworkStub::DiagnoseRouter(
    grpc::ClientContext& context, Options const&,
    google::cloud::edgenetwork::v1::DiagnoseRouterRequest const& request) {
  google::cloud::edgenetwork::v1::DiagnoseRouterResponse response;
  auto status = grpc_stub_->DiagnoseRouter(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncCreateRouter(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::CreateRouterRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::CreateRouterRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::CreateRouterRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateRouter(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::CreateRouter(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::CreateRouterRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateRouter(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncUpdateRouter(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::UpdateRouterRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::UpdateRouterRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::UpdateRouterRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateRouter(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::UpdateRouter(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::UpdateRouterRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateRouter(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncDeleteRouter(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::edgenetwork::v1::DeleteRouterRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::edgenetwork::v1::DeleteRouterRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::edgenetwork::v1::DeleteRouterRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteRouter(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::DeleteRouter(
    grpc::ClientContext& context, Options,
    google::cloud::edgenetwork::v1::DeleteRouterRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteRouter(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::location::ListLocationsResponse>
DefaultEdgeNetworkStub::ListLocations(
    grpc::ClientContext& context, Options const&,
    google::cloud::location::ListLocationsRequest const& request) {
  google::cloud::location::ListLocationsResponse response;
  auto status = locations_stub_->ListLocations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::location::Location> DefaultEdgeNetworkStub::GetLocation(
    grpc::ClientContext& context, Options const&,
    google::cloud::location::GetLocationRequest const& request) {
  google::cloud::location::Location response;
  auto status = locations_stub_->GetLocation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::longrunning::ListOperationsResponse>
DefaultEdgeNetworkStub::ListOperations(
    grpc::ClientContext& context, Options const&,
    google::longrunning::ListOperationsRequest const& request) {
  google::longrunning::ListOperationsResponse response;
  auto status = operations_stub_->ListOperations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::longrunning::Operation> DefaultEdgeNetworkStub::GetOperation(
    grpc::ClientContext& context, Options const&,
    google::longrunning::GetOperationRequest const& request) {
  google::longrunning::Operation response;
  auto status = operations_stub_->GetOperation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultEdgeNetworkStub::DeleteOperation(
    grpc::ClientContext& context, Options const&,
    google::longrunning::DeleteOperationRequest const& request) {
  google::protobuf::Empty response;
  auto status = operations_stub_->DeleteOperation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

Status DefaultEdgeNetworkStub::CancelOperation(
    grpc::ClientContext& context, Options const&,
    google::longrunning::CancelOperationRequest const& request) {
  google::protobuf::Empty response;
  auto status = operations_stub_->CancelOperation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

future<StatusOr<google::longrunning::Operation>>
DefaultEdgeNetworkStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultEdgeNetworkStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1_internal
}  // namespace cloud
}  // namespace google
