// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#include "google/cloud/edgenetwork/v1/edge_network_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace edgenetwork_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

EdgeNetworkConnectionIdempotencyPolicy::
    ~EdgeNetworkConnectionIdempotencyPolicy() = default;

std::unique_ptr<EdgeNetworkConnectionIdempotencyPolicy>
EdgeNetworkConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<EdgeNetworkConnectionIdempotencyPolicy>(*this);
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::InitializeZone(
    google::cloud::edgenetwork::v1::InitializeZoneRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListZones(
    google::cloud::edgenetwork::v1::ListZonesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetZone(
    google::cloud::edgenetwork::v1::GetZoneRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListNetworks(
    google::cloud::edgenetwork::v1::ListNetworksRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetNetwork(
    google::cloud::edgenetwork::v1::GetNetworkRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::DiagnoseNetwork(
    google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::CreateNetwork(
    google::cloud::edgenetwork::v1::CreateNetworkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::DeleteNetwork(
    google::cloud::edgenetwork::v1::DeleteNetworkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListSubnets(
    google::cloud::edgenetwork::v1::ListSubnetsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetSubnet(
    google::cloud::edgenetwork::v1::GetSubnetRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::CreateSubnet(
    google::cloud::edgenetwork::v1::CreateSubnetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::UpdateSubnet(
    google::cloud::edgenetwork::v1::UpdateSubnetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::DeleteSubnet(
    google::cloud::edgenetwork::v1::DeleteSubnetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListInterconnects(
    google::cloud::edgenetwork::v1::ListInterconnectsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetInterconnect(
    google::cloud::edgenetwork::v1::GetInterconnectRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::DiagnoseInterconnect(
    google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListInterconnectAttachments(
    google::cloud::edgenetwork::v1::
        ListInterconnectAttachmentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetInterconnectAttachment(
    google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
EdgeNetworkConnectionIdempotencyPolicy::CreateInterconnectAttachment(
    google::cloud::edgenetwork::v1::
        CreateInterconnectAttachmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
EdgeNetworkConnectionIdempotencyPolicy::DeleteInterconnectAttachment(
    google::cloud::edgenetwork::v1::
        DeleteInterconnectAttachmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListRouters(
    google::cloud::edgenetwork::v1::ListRoutersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetRouter(
    google::cloud::edgenetwork::v1::GetRouterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::DiagnoseRouter(
    google::cloud::edgenetwork::v1::DiagnoseRouterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::CreateRouter(
    google::cloud::edgenetwork::v1::CreateRouterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::UpdateRouter(
    google::cloud::edgenetwork::v1::UpdateRouterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::DeleteRouter(
    google::cloud::edgenetwork::v1::DeleteRouterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EdgeNetworkConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<EdgeNetworkConnectionIdempotencyPolicy>
MakeDefaultEdgeNetworkConnectionIdempotencyPolicy() {
  return std::make_unique<EdgeNetworkConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1
}  // namespace cloud
}  // namespace google
