// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgecontainer/v1/service.proto

#include "google/cloud/edgecontainer/v1/internal/edge_container_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace edgecontainer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EdgeContainerTracingStub::EdgeContainerTracingStub(
    std::shared_ptr<EdgeContainerStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::edgecontainer::v1::ListClustersResponse>
EdgeContainerTracingStub::ListClusters(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::ListClustersRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "ListClusters");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListClusters(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::Cluster>
EdgeContainerTracingStub::GetCluster(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::GetClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GetCluster");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCluster(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncCreateCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::CreateClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "CreateCluster");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateCluster(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::CreateCluster(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::CreateClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "CreateCluster");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateCluster(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncUpdateCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::UpdateClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "UpdateCluster");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateCluster(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::UpdateCluster(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::UpdateClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "UpdateCluster");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateCluster(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncUpgradeCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::UpgradeClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "UpgradeCluster");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpgradeCluster(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::UpgradeCluster(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::UpgradeClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "UpgradeCluster");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpgradeCluster(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncDeleteCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::DeleteClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "DeleteCluster");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteCluster(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::DeleteCluster(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::DeleteClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "DeleteCluster");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteCluster(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::GenerateAccessTokenResponse>
EdgeContainerTracingStub::GenerateAccessToken(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::GenerateAccessTokenRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GenerateAccessToken");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GenerateAccessToken(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::GenerateOfflineCredentialResponse>
EdgeContainerTracingStub::GenerateOfflineCredential(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::GenerateOfflineCredentialRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.edgecontainer.v1.EdgeContainer",
                             "GenerateOfflineCredential");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GenerateOfflineCredential(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::ListNodePoolsResponse>
EdgeContainerTracingStub::ListNodePools(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::ListNodePoolsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "ListNodePools");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListNodePools(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::NodePool>
EdgeContainerTracingStub::GetNodePool(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::GetNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GetNodePool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetNodePool(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncCreateNodePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::CreateNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "CreateNodePool");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateNodePool(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::CreateNodePool(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::CreateNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "CreateNodePool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateNodePool(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncUpdateNodePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::UpdateNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "UpdateNodePool");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateNodePool(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::UpdateNodePool(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::UpdateNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "UpdateNodePool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateNodePool(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncDeleteNodePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::DeleteNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "DeleteNodePool");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteNodePool(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::DeleteNodePool(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::DeleteNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "DeleteNodePool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteNodePool(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::ListMachinesResponse>
EdgeContainerTracingStub::ListMachines(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::ListMachinesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "ListMachines");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListMachines(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::Machine>
EdgeContainerTracingStub::GetMachine(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::GetMachineRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GetMachine");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetMachine(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::ListVpnConnectionsResponse>
EdgeContainerTracingStub::ListVpnConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::ListVpnConnectionsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "ListVpnConnections");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListVpnConnections(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::VpnConnection>
EdgeContainerTracingStub::GetVpnConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::GetVpnConnectionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GetVpnConnection");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetVpnConnection(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncCreateVpnConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::CreateVpnConnectionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "CreateVpnConnection");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateVpnConnection(cq, context, std::move(options),
                                            request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::CreateVpnConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::CreateVpnConnectionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "CreateVpnConnection");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateVpnConnection(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncDeleteVpnConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "DeleteVpnConnection");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteVpnConnection(cq, context, std::move(options),
                                            request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
EdgeContainerTracingStub::DeleteVpnConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "DeleteVpnConnection");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteVpnConnection(context, options, request));
}

StatusOr<google::cloud::edgecontainer::v1::ServerConfig>
EdgeContainerTracingStub::GetServerConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::edgecontainer::v1::GetServerConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GetServerConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetServerConfig(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
EdgeContainerTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
EdgeContainerTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
EdgeContainerTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation> EdgeContainerTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status EdgeContainerTracingStub::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteOperation(context, options, request));
}

Status EdgeContainerTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.edgecontainer.v1.EdgeContainer", "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
EdgeContainerTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> EdgeContainerTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<EdgeContainerStub> MakeEdgeContainerTracingStub(
    std::shared_ptr<EdgeContainerStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<EdgeContainerTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgecontainer_v1_internal
}  // namespace cloud
}  // namespace google
