// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/documentai/v1/document_processor_service.proto

#include "google/cloud/documentai/v1/internal/document_processor_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace documentai_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DocumentProcessorServiceTracingStub::DocumentProcessorServiceTracingStub(
    std::shared_ptr<DocumentProcessorServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::documentai::v1::ProcessResponse>
DocumentProcessorServiceTracingStub::ProcessDocument(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::ProcessRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ProcessDocument");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ProcessDocument(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncBatchProcessDocuments(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::BatchProcessRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "BatchProcessDocuments");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncBatchProcessDocuments(cq, context, std::move(options),
                                              request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::BatchProcessDocuments(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::BatchProcessRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "BatchProcessDocuments");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->BatchProcessDocuments(context, options, request));
}

StatusOr<google::cloud::documentai::v1::FetchProcessorTypesResponse>
DocumentProcessorServiceTracingStub::FetchProcessorTypes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::FetchProcessorTypesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "FetchProcessorTypes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->FetchProcessorTypes(context, options, request));
}

StatusOr<google::cloud::documentai::v1::ListProcessorTypesResponse>
DocumentProcessorServiceTracingStub::ListProcessorTypes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::ListProcessorTypesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "ListProcessorTypes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListProcessorTypes(context, options, request));
}

StatusOr<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceTracingStub::GetProcessorType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::GetProcessorTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "GetProcessorType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProcessorType(context, options, request));
}

StatusOr<google::cloud::documentai::v1::ListProcessorsResponse>
DocumentProcessorServiceTracingStub::ListProcessors(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::ListProcessorsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ListProcessors");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListProcessors(context, options, request));
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceTracingStub::GetProcessor(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::GetProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "GetProcessor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProcessor(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncTrainProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::TrainProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "TrainProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncTrainProcessorVersion(cq, context, std::move(options),
                                              request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::TrainProcessorVersion(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::TrainProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "TrainProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->TrainProcessorVersion(context, options, request));
}

StatusOr<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceTracingStub::GetProcessorVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::GetProcessorVersionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "GetProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetProcessorVersion(context, options, request));
}

StatusOr<google::cloud::documentai::v1::ListProcessorVersionsResponse>
DocumentProcessorServiceTracingStub::ListProcessorVersions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::ListProcessorVersionsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "ListProcessorVersions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListProcessorVersions(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDeleteProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::DeleteProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DeleteProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteProcessorVersion(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::DeleteProcessorVersion(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::DeleteProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DeleteProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DeleteProcessorVersion(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDeployProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::DeployProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DeployProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeployProcessorVersion(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::DeployProcessorVersion(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::DeployProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DeployProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DeployProcessorVersion(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncUndeployProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "UndeployProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUndeployProcessorVersion(cq, context,
                                                 std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::UndeployProcessorVersion(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "UndeployProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->UndeployProcessorVersion(context, options, request));
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceTracingStub::CreateProcessor(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::CreateProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "CreateProcessor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateProcessor(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDeleteProcessor(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::DeleteProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "DeleteProcessor");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteProcessor(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::DeleteProcessor(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::DeleteProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "DeleteProcessor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteProcessor(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncEnableProcessor(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::EnableProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "EnableProcessor");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncEnableProcessor(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::EnableProcessor(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::EnableProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "EnableProcessor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->EnableProcessor(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDisableProcessor(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::DisableProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DisableProcessor");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDisableProcessor(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::DisableProcessor(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::DisableProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DisableProcessor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DisableProcessor(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncSetDefaultProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "SetDefaultProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncSetDefaultProcessorVersion(cq, context,
                                                   std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::SetDefaultProcessorVersion(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "SetDefaultProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->SetDefaultProcessorVersion(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncReviewDocument(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::ReviewDocumentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ReviewDocument");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncReviewDocument(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::ReviewDocument(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::ReviewDocumentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ReviewDocument");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ReviewDocument(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncEvaluateProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "EvaluateProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncEvaluateProcessorVersion(cq, context,
                                                 std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::EvaluateProcessorVersion(
    grpc::ClientContext& context, Options options,
    google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "EvaluateProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->EvaluateProcessorVersion(context, options, request));
}

StatusOr<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceTracingStub::GetEvaluation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::GetEvaluationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "GetEvaluation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEvaluation(context, options, request));
}

StatusOr<google::cloud::documentai::v1::ListEvaluationsResponse>
DocumentProcessorServiceTracingStub::ListEvaluations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::documentai::v1::ListEvaluationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ListEvaluations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEvaluations(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
DocumentProcessorServiceTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
DocumentProcessorServiceTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
DocumentProcessorServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status DocumentProcessorServiceTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> DocumentProcessorServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<DocumentProcessorServiceStub>
MakeDocumentProcessorServiceTracingStub(
    std::shared_ptr<DocumentProcessorServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<DocumentProcessorServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace documentai_v1_internal
}  // namespace cloud
}  // namespace google
