// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/documentai/v1/document_processor_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOCUMENTAI_V1_DOCUMENT_PROCESSOR_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOCUMENTAI_V1_DOCUMENT_PROCESSOR_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/documentai/v1/document_processor_service.grpc.pb.h>
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace documentai_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DocumentProcessorServiceConnectionIdempotencyPolicy {
 public:
  virtual ~DocumentProcessorServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<DocumentProcessorServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency ProcessDocument(
      google::cloud::documentai::v1::ProcessRequest const& request);

  virtual google::cloud::Idempotency BatchProcessDocuments(
      google::cloud::documentai::v1::BatchProcessRequest const& request);

  virtual google::cloud::Idempotency FetchProcessorTypes(
      google::cloud::documentai::v1::FetchProcessorTypesRequest const& request);

  virtual google::cloud::Idempotency ListProcessorTypes(
      google::cloud::documentai::v1::ListProcessorTypesRequest request);

  virtual google::cloud::Idempotency GetProcessorType(
      google::cloud::documentai::v1::GetProcessorTypeRequest const& request);

  virtual google::cloud::Idempotency ListProcessors(
      google::cloud::documentai::v1::ListProcessorsRequest request);

  virtual google::cloud::Idempotency GetProcessor(
      google::cloud::documentai::v1::GetProcessorRequest const& request);

  virtual google::cloud::Idempotency TrainProcessorVersion(
      google::cloud::documentai::v1::TrainProcessorVersionRequest const&
          request);

  virtual google::cloud::Idempotency GetProcessorVersion(
      google::cloud::documentai::v1::GetProcessorVersionRequest const& request);

  virtual google::cloud::Idempotency ListProcessorVersions(
      google::cloud::documentai::v1::ListProcessorVersionsRequest request);

  virtual google::cloud::Idempotency DeleteProcessorVersion(
      google::cloud::documentai::v1::DeleteProcessorVersionRequest const&
          request);

  virtual google::cloud::Idempotency DeployProcessorVersion(
      google::cloud::documentai::v1::DeployProcessorVersionRequest const&
          request);

  virtual google::cloud::Idempotency UndeployProcessorVersion(
      google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
          request);

  virtual google::cloud::Idempotency CreateProcessor(
      google::cloud::documentai::v1::CreateProcessorRequest const& request);

  virtual google::cloud::Idempotency DeleteProcessor(
      google::cloud::documentai::v1::DeleteProcessorRequest const& request);

  virtual google::cloud::Idempotency EnableProcessor(
      google::cloud::documentai::v1::EnableProcessorRequest const& request);

  virtual google::cloud::Idempotency DisableProcessor(
      google::cloud::documentai::v1::DisableProcessorRequest const& request);

  virtual google::cloud::Idempotency SetDefaultProcessorVersion(
      google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
          request);

  virtual google::cloud::Idempotency ReviewDocument(
      google::cloud::documentai::v1::ReviewDocumentRequest const& request);

  virtual google::cloud::Idempotency EvaluateProcessorVersion(
      google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
          request);

  virtual google::cloud::Idempotency GetEvaluation(
      google::cloud::documentai::v1::GetEvaluationRequest const& request);

  virtual google::cloud::Idempotency ListEvaluations(
      google::cloud::documentai::v1::ListEvaluationsRequest request);

  virtual google::cloud::Idempotency ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual google::cloud::Idempotency GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

std::unique_ptr<DocumentProcessorServiceConnectionIdempotencyPolicy>
MakeDefaultDocumentProcessorServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace documentai_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOCUMENTAI_V1_DOCUMENT_PROCESSOR_CONNECTION_IDEMPOTENCY_POLICY_H
