// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/documentai/v1/document_processor_service.proto

#include "google/cloud/documentai/v1/document_processor_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace documentai_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentProcessorServiceClient::DocumentProcessorServiceClient(
    std::shared_ptr<DocumentProcessorServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DocumentProcessorServiceClient::~DocumentProcessorServiceClient() = default;

StatusOr<google::cloud::documentai::v1::ProcessResponse>
DocumentProcessorServiceClient::ProcessDocument(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::ProcessRequest request;
  request.set_name(name);
  return connection_->ProcessDocument(request);
}

StatusOr<google::cloud::documentai::v1::ProcessResponse>
DocumentProcessorServiceClient::ProcessDocument(
    google::cloud::documentai::v1::ProcessRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ProcessDocument(request);
}

future<StatusOr<google::cloud::documentai::v1::BatchProcessResponse>>
DocumentProcessorServiceClient::BatchProcessDocuments(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::BatchProcessRequest request;
  request.set_name(name);
  return connection_->BatchProcessDocuments(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::BatchProcessDocuments(NoAwaitTag,
                                                      std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::BatchProcessRequest request;
  request.set_name(name);
  return connection_->BatchProcessDocuments(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::BatchProcessResponse>>
DocumentProcessorServiceClient::BatchProcessDocuments(
    google::cloud::documentai::v1::BatchProcessRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchProcessDocuments(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::BatchProcessDocuments(
    NoAwaitTag,
    google::cloud::documentai::v1::BatchProcessRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchProcessDocuments(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::BatchProcessResponse>>
DocumentProcessorServiceClient::BatchProcessDocuments(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchProcessDocuments(operation);
}

StatusOr<google::cloud::documentai::v1::FetchProcessorTypesResponse>
DocumentProcessorServiceClient::FetchProcessorTypes(std::string const& parent,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::FetchProcessorTypesRequest request;
  request.set_parent(parent);
  return connection_->FetchProcessorTypes(request);
}

StatusOr<google::cloud::documentai::v1::FetchProcessorTypesResponse>
DocumentProcessorServiceClient::FetchProcessorTypes(
    google::cloud::documentai::v1::FetchProcessorTypesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FetchProcessorTypes(request);
}

StreamRange<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceClient::ListProcessorTypes(std::string const& parent,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::ListProcessorTypesRequest request;
  request.set_parent(parent);
  return connection_->ListProcessorTypes(request);
}

StreamRange<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceClient::ListProcessorTypes(
    google::cloud::documentai::v1::ListProcessorTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListProcessorTypes(std::move(request));
}

StatusOr<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceClient::GetProcessorType(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::GetProcessorTypeRequest request;
  request.set_name(name);
  return connection_->GetProcessorType(request);
}

StatusOr<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceClient::GetProcessorType(
    google::cloud::documentai::v1::GetProcessorTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetProcessorType(request);
}

StreamRange<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceClient::ListProcessors(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::ListProcessorsRequest request;
  request.set_parent(parent);
  return connection_->ListProcessors(request);
}

StreamRange<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceClient::ListProcessors(
    google::cloud::documentai::v1::ListProcessorsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListProcessors(std::move(request));
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceClient::GetProcessor(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::GetProcessorRequest request;
  request.set_name(name);
  return connection_->GetProcessor(request);
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceClient::GetProcessor(
    google::cloud::documentai::v1::GetProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetProcessor(request);
}

future<StatusOr<google::cloud::documentai::v1::TrainProcessorVersionResponse>>
DocumentProcessorServiceClient::TrainProcessorVersion(
    std::string const& parent,
    google::cloud::documentai::v1::ProcessorVersion const& processor_version,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::TrainProcessorVersionRequest request;
  request.set_parent(parent);
  *request.mutable_processor_version() = processor_version;
  return connection_->TrainProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::TrainProcessorVersion(
    NoAwaitTag, std::string const& parent,
    google::cloud::documentai::v1::ProcessorVersion const& processor_version,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::TrainProcessorVersionRequest request;
  request.set_parent(parent);
  *request.mutable_processor_version() = processor_version;
  return connection_->TrainProcessorVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::TrainProcessorVersionResponse>>
DocumentProcessorServiceClient::TrainProcessorVersion(
    google::cloud::documentai::v1::TrainProcessorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TrainProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::TrainProcessorVersion(
    NoAwaitTag,
    google::cloud::documentai::v1::TrainProcessorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TrainProcessorVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::TrainProcessorVersionResponse>>
DocumentProcessorServiceClient::TrainProcessorVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TrainProcessorVersion(operation);
}

StatusOr<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceClient::GetProcessorVersion(std::string const& name,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::GetProcessorVersionRequest request;
  request.set_name(name);
  return connection_->GetProcessorVersion(request);
}

StatusOr<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceClient::GetProcessorVersion(
    google::cloud::documentai::v1::GetProcessorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetProcessorVersion(request);
}

StreamRange<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceClient::ListProcessorVersions(std::string const& parent,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::ListProcessorVersionsRequest request;
  request.set_parent(parent);
  return connection_->ListProcessorVersions(request);
}

StreamRange<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceClient::ListProcessorVersions(
    google::cloud::documentai::v1::ListProcessorVersionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListProcessorVersions(std::move(request));
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorVersionMetadata>>
DocumentProcessorServiceClient::DeleteProcessorVersion(std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::DeleteProcessorVersionRequest request;
  request.set_name(name);
  return connection_->DeleteProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::DeleteProcessorVersion(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::DeleteProcessorVersionRequest request;
  request.set_name(name);
  return connection_->DeleteProcessorVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorVersionMetadata>>
DocumentProcessorServiceClient::DeleteProcessorVersion(
    google::cloud::documentai::v1::DeleteProcessorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::DeleteProcessorVersion(
    NoAwaitTag,
    google::cloud::documentai::v1::DeleteProcessorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcessorVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorVersionMetadata>>
DocumentProcessorServiceClient::DeleteProcessorVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcessorVersion(operation);
}

future<StatusOr<google::cloud::documentai::v1::DeployProcessorVersionResponse>>
DocumentProcessorServiceClient::DeployProcessorVersion(std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::DeployProcessorVersionRequest request;
  request.set_name(name);
  return connection_->DeployProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::DeployProcessorVersion(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::DeployProcessorVersionRequest request;
  request.set_name(name);
  return connection_->DeployProcessorVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::DeployProcessorVersionResponse>>
DocumentProcessorServiceClient::DeployProcessorVersion(
    google::cloud::documentai::v1::DeployProcessorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::DeployProcessorVersion(
    NoAwaitTag,
    google::cloud::documentai::v1::DeployProcessorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployProcessorVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::DeployProcessorVersionResponse>>
DocumentProcessorServiceClient::DeployProcessorVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployProcessorVersion(operation);
}

future<
    StatusOr<google::cloud::documentai::v1::UndeployProcessorVersionResponse>>
DocumentProcessorServiceClient::UndeployProcessorVersion(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::UndeployProcessorVersionRequest request;
  request.set_name(name);
  return connection_->UndeployProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::UndeployProcessorVersion(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::UndeployProcessorVersionRequest request;
  request.set_name(name);
  return connection_->UndeployProcessorVersion(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::documentai::v1::UndeployProcessorVersionResponse>>
DocumentProcessorServiceClient::UndeployProcessorVersion(
    google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::UndeployProcessorVersion(
    NoAwaitTag,
    google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployProcessorVersion(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::documentai::v1::UndeployProcessorVersionResponse>>
DocumentProcessorServiceClient::UndeployProcessorVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployProcessorVersion(operation);
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceClient::CreateProcessor(
    std::string const& parent,
    google::cloud::documentai::v1::Processor const& processor, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::CreateProcessorRequest request;
  request.set_parent(parent);
  *request.mutable_processor() = processor;
  return connection_->CreateProcessor(request);
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceClient::CreateProcessor(
    google::cloud::documentai::v1::CreateProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateProcessor(request);
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorMetadata>>
DocumentProcessorServiceClient::DeleteProcessor(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::DeleteProcessorRequest request;
  request.set_name(name);
  return connection_->DeleteProcessor(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::DeleteProcessor(NoAwaitTag,
                                                std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::DeleteProcessorRequest request;
  request.set_name(name);
  return connection_->DeleteProcessor(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorMetadata>>
DocumentProcessorServiceClient::DeleteProcessor(
    google::cloud::documentai::v1::DeleteProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcessor(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::DeleteProcessor(
    NoAwaitTag,
    google::cloud::documentai::v1::DeleteProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcessor(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorMetadata>>
DocumentProcessorServiceClient::DeleteProcessor(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteProcessor(operation);
}

future<StatusOr<google::cloud::documentai::v1::EnableProcessorResponse>>
DocumentProcessorServiceClient::EnableProcessor(
    google::cloud::documentai::v1::EnableProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableProcessor(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::EnableProcessor(
    NoAwaitTag,
    google::cloud::documentai::v1::EnableProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableProcessor(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::EnableProcessorResponse>>
DocumentProcessorServiceClient::EnableProcessor(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableProcessor(operation);
}

future<StatusOr<google::cloud::documentai::v1::DisableProcessorResponse>>
DocumentProcessorServiceClient::DisableProcessor(
    google::cloud::documentai::v1::DisableProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableProcessor(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::DisableProcessor(
    NoAwaitTag,
    google::cloud::documentai::v1::DisableProcessorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableProcessor(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::DisableProcessorResponse>>
DocumentProcessorServiceClient::DisableProcessor(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableProcessor(operation);
}

future<
    StatusOr<google::cloud::documentai::v1::SetDefaultProcessorVersionResponse>>
DocumentProcessorServiceClient::SetDefaultProcessorVersion(
    google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetDefaultProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::SetDefaultProcessorVersion(
    NoAwaitTag,
    google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetDefaultProcessorVersion(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::documentai::v1::SetDefaultProcessorVersionResponse>>
DocumentProcessorServiceClient::SetDefaultProcessorVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetDefaultProcessorVersion(operation);
}

future<StatusOr<google::cloud::documentai::v1::ReviewDocumentResponse>>
DocumentProcessorServiceClient::ReviewDocument(
    std::string const& human_review_config, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::ReviewDocumentRequest request;
  request.set_human_review_config(human_review_config);
  return connection_->ReviewDocument(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::ReviewDocument(
    NoAwaitTag, std::string const& human_review_config, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::ReviewDocumentRequest request;
  request.set_human_review_config(human_review_config);
  return connection_->ReviewDocument(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::ReviewDocumentResponse>>
DocumentProcessorServiceClient::ReviewDocument(
    google::cloud::documentai::v1::ReviewDocumentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReviewDocument(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::ReviewDocument(
    NoAwaitTag,
    google::cloud::documentai::v1::ReviewDocumentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReviewDocument(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::documentai::v1::ReviewDocumentResponse>>
DocumentProcessorServiceClient::ReviewDocument(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReviewDocument(operation);
}

future<
    StatusOr<google::cloud::documentai::v1::EvaluateProcessorVersionResponse>>
DocumentProcessorServiceClient::EvaluateProcessorVersion(
    std::string const& processor_version, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::EvaluateProcessorVersionRequest request;
  request.set_processor_version(processor_version);
  return connection_->EvaluateProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::EvaluateProcessorVersion(
    NoAwaitTag, std::string const& processor_version, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::EvaluateProcessorVersionRequest request;
  request.set_processor_version(processor_version);
  return connection_->EvaluateProcessorVersion(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::documentai::v1::EvaluateProcessorVersionResponse>>
DocumentProcessorServiceClient::EvaluateProcessorVersion(
    google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EvaluateProcessorVersion(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::EvaluateProcessorVersion(
    NoAwaitTag,
    google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EvaluateProcessorVersion(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::documentai::v1::EvaluateProcessorVersionResponse>>
DocumentProcessorServiceClient::EvaluateProcessorVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EvaluateProcessorVersion(operation);
}

StatusOr<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceClient::GetEvaluation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::GetEvaluationRequest request;
  request.set_name(name);
  return connection_->GetEvaluation(request);
}

StatusOr<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceClient::GetEvaluation(
    google::cloud::documentai::v1::GetEvaluationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEvaluation(request);
}

StreamRange<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceClient::ListEvaluations(std::string const& parent,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::documentai::v1::ListEvaluationsRequest request;
  request.set_parent(parent);
  return connection_->ListEvaluations(request);
}

StreamRange<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceClient::ListEvaluations(
    google::cloud::documentai::v1::ListEvaluationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEvaluations(std::move(request));
}

StreamRange<google::cloud::location::Location>
DocumentProcessorServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
DocumentProcessorServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation>
DocumentProcessorServiceClient::ListOperations(std::string const& name,
                                               std::string const& filter,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
DocumentProcessorServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::GetOperation(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
DocumentProcessorServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status DocumentProcessorServiceClient::CancelOperation(std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status DocumentProcessorServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace documentai_v1
}  // namespace cloud
}  // namespace google
