// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CONNECTION_H

#include "google/cloud/discoveryengine/v1/internal/site_search_engine_retry_traits.h"
#include "google/cloud/discoveryengine/v1/site_search_engine_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/discoveryengine/v1/site_search_engine_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `SiteSearchEngineServiceConnection`.
class SiteSearchEngineServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<SiteSearchEngineServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `SiteSearchEngineServiceConnection` based on counting
 * errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class SiteSearchEngineServiceLimitedErrorCountRetryPolicy
    : public SiteSearchEngineServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit SiteSearchEngineServiceLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  SiteSearchEngineServiceLimitedErrorCountRetryPolicy(
      SiteSearchEngineServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : SiteSearchEngineServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  SiteSearchEngineServiceLimitedErrorCountRetryPolicy(
      SiteSearchEngineServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : SiteSearchEngineServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<SiteSearchEngineServiceRetryPolicy> clone() const override {
    return std::make_unique<
        SiteSearchEngineServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = SiteSearchEngineServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      discoveryengine_v1_internal::SiteSearchEngineServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `SiteSearchEngineServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class SiteSearchEngineServiceLimitedTimeRetryPolicy
    : public SiteSearchEngineServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit SiteSearchEngineServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  SiteSearchEngineServiceLimitedTimeRetryPolicy(
      SiteSearchEngineServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : SiteSearchEngineServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  SiteSearchEngineServiceLimitedTimeRetryPolicy(
      SiteSearchEngineServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : SiteSearchEngineServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<SiteSearchEngineServiceRetryPolicy> clone() const override {
    return std::make_unique<SiteSearchEngineServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = SiteSearchEngineServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      discoveryengine_v1_internal::SiteSearchEngineServiceRetryTraits>
      impl_;
};

/**
 * The `SiteSearchEngineServiceConnection` object for
 * `SiteSearchEngineServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `SiteSearchEngineServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `SiteSearchEngineServiceClient`.
 *
 * To create a concrete instance, see `MakeSiteSearchEngineServiceConnection()`.
 *
 * For mocking, see
 * `discoveryengine_v1_mocks::MockSiteSearchEngineServiceConnection`.
 */
class SiteSearchEngineServiceConnection {
 public:
  virtual ~SiteSearchEngineServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
  GetSiteSearchEngine(
      google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
          request);

  virtual future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  CreateTargetSite(
      google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateTargetSite(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
          request);

  virtual future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  CreateTargetSite(google::longrunning::Operation const& operation);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
  BatchCreateTargetSites(
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> BatchCreateTargetSites(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
          request);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
  BatchCreateTargetSites(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::discoveryengine::v1::TargetSite>
  GetTargetSite(
      google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request);

  virtual future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  UpdateTargetSite(
      google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateTargetSite(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
          request);

  virtual future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  UpdateTargetSite(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
  DeleteTargetSite(
      google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteTargetSite(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
  DeleteTargetSite(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::discoveryengine::v1::TargetSite>
  ListTargetSites(
      google::cloud::discoveryengine::v1::ListTargetSitesRequest request);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
  EnableAdvancedSiteSearch(
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> EnableAdvancedSiteSearch(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
          request);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
  EnableAdvancedSiteSearch(google::longrunning::Operation const& operation);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
  DisableAdvancedSiteSearch(
      google::cloud::discoveryengine::v1::
          DisableAdvancedSiteSearchRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DisableAdvancedSiteSearch(
      NoAwaitTag, google::cloud::discoveryengine::v1::
                      DisableAdvancedSiteSearchRequest const& request);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
  DisableAdvancedSiteSearch(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
  RecrawlUris(
      google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request);

  virtual StatusOr<google::longrunning::Operation> RecrawlUris(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request);

  virtual future<
      StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
  RecrawlUris(google::longrunning::Operation const& operation);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
  BatchVerifyTargetSites(
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> BatchVerifyTargetSites(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
          request);

  virtual future<StatusOr<
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
  BatchVerifyTargetSites(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::discoveryengine::v1::TargetSite>
  FetchDomainVerificationStatus(
      google::cloud::discoveryengine::v1::FetchDomainVerificationStatusRequest
          request);

  virtual StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `SiteSearchEngineServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * SiteSearchEngineServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `SiteSearchEngineServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * -
 * `google::cloud::discoveryengine_v1::SiteSearchEngineServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `SiteSearchEngineServiceConnection`
 * created by this function.
 */
std::shared_ptr<SiteSearchEngineServiceConnection>
MakeSiteSearchEngineServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CONNECTION_H
