// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#include "google/cloud/discoveryengine/v1/site_search_engine_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SiteSearchEngineServiceClient::SiteSearchEngineServiceClient(
    std::shared_ptr<SiteSearchEngineServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SiteSearchEngineServiceClient::~SiteSearchEngineServiceClient() = default;

StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
SiteSearchEngineServiceClient::GetSiteSearchEngine(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest request;
  request.set_name(name);
  return connection_->GetSiteSearchEngine(request);
}

StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
SiteSearchEngineServiceClient::GetSiteSearchEngine(
    google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSiteSearchEngine(request);
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceClient::CreateTargetSite(
    std::string const& parent,
    google::cloud::discoveryengine::v1::TargetSite const& target_site,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::CreateTargetSiteRequest request;
  request.set_parent(parent);
  *request.mutable_target_site() = target_site;
  return connection_->CreateTargetSite(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::CreateTargetSite(
    NoAwaitTag, std::string const& parent,
    google::cloud::discoveryengine::v1::TargetSite const& target_site,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::CreateTargetSiteRequest request;
  request.set_parent(parent);
  *request.mutable_target_site() = target_site;
  return connection_->CreateTargetSite(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceClient::CreateTargetSite(
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTargetSite(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::CreateTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTargetSite(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceClient::CreateTargetSite(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTargetSite(operation);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
SiteSearchEngineServiceClient::BatchCreateTargetSites(
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateTargetSites(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::BatchCreateTargetSites(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateTargetSites(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
SiteSearchEngineServiceClient::BatchCreateTargetSites(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateTargetSites(operation);
}

StatusOr<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceClient::GetTargetSite(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::GetTargetSiteRequest request;
  request.set_name(name);
  return connection_->GetTargetSite(request);
}

StatusOr<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceClient::GetTargetSite(
    google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTargetSite(request);
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceClient::UpdateTargetSite(
    google::cloud::discoveryengine::v1::TargetSite const& target_site,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::UpdateTargetSiteRequest request;
  *request.mutable_target_site() = target_site;
  return connection_->UpdateTargetSite(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::UpdateTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::TargetSite const& target_site,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::UpdateTargetSiteRequest request;
  *request.mutable_target_site() = target_site;
  return connection_->UpdateTargetSite(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceClient::UpdateTargetSite(
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTargetSite(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::UpdateTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTargetSite(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceClient::UpdateTargetSite(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTargetSite(operation);
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
SiteSearchEngineServiceClient::DeleteTargetSite(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::DeleteTargetSiteRequest request;
  request.set_name(name);
  return connection_->DeleteTargetSite(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::DeleteTargetSite(NoAwaitTag,
                                                std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::DeleteTargetSiteRequest request;
  request.set_name(name);
  return connection_->DeleteTargetSite(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
SiteSearchEngineServiceClient::DeleteTargetSite(
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTargetSite(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::DeleteTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTargetSite(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
SiteSearchEngineServiceClient::DeleteTargetSite(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTargetSite(operation);
}

StreamRange<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceClient::ListTargetSites(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::ListTargetSitesRequest request;
  request.set_parent(parent);
  return connection_->ListTargetSites(request);
}

StreamRange<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceClient::ListTargetSites(
    google::cloud::discoveryengine::v1::ListTargetSitesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTargetSites(std::move(request));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceClient::EnableAdvancedSiteSearch(
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableAdvancedSiteSearch(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::EnableAdvancedSiteSearch(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableAdvancedSiteSearch(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceClient::EnableAdvancedSiteSearch(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableAdvancedSiteSearch(operation);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceClient::DisableAdvancedSiteSearch(
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableAdvancedSiteSearch(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::DisableAdvancedSiteSearch(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableAdvancedSiteSearch(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceClient::DisableAdvancedSiteSearch(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableAdvancedSiteSearch(operation);
}

future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
SiteSearchEngineServiceClient::RecrawlUris(
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RecrawlUris(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::RecrawlUris(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RecrawlUris(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
SiteSearchEngineServiceClient::RecrawlUris(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RecrawlUris(operation);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
SiteSearchEngineServiceClient::BatchVerifyTargetSites(
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchVerifyTargetSites(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::BatchVerifyTargetSites(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchVerifyTargetSites(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
SiteSearchEngineServiceClient::BatchVerifyTargetSites(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchVerifyTargetSites(operation);
}

StreamRange<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceClient::FetchDomainVerificationStatus(
    google::cloud::discoveryengine::v1::FetchDomainVerificationStatusRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FetchDomainVerificationStatus(std::move(request));
}

StreamRange<google::longrunning::Operation>
SiteSearchEngineServiceClient::ListOperations(std::string const& name,
                                              std::string const& filter,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
SiteSearchEngineServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::GetOperation(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status SiteSearchEngineServiceClient::CancelOperation(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status SiteSearchEngineServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
