// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/schema_service.proto

#include "google/cloud/discoveryengine/v1/schema_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SchemaServiceConnectionIdempotencyPolicy::
    ~SchemaServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<SchemaServiceConnectionIdempotencyPolicy>
SchemaServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SchemaServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::GetSchema(
    google::cloud::discoveryengine::v1::GetSchemaRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::ListSchemas(
    google::cloud::discoveryengine::v1::ListSchemasRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::CreateSchema(
    google::cloud::discoveryengine::v1::CreateSchemaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::UpdateSchema(
    google::cloud::discoveryengine::v1::UpdateSchemaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::DeleteSchema(
    google::cloud::discoveryengine::v1::DeleteSchemaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SchemaServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SchemaServiceConnectionIdempotencyPolicy>
MakeDefaultSchemaServiceConnectionIdempotencyPolicy() {
  return std::make_unique<SchemaServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
