// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#include "google/cloud/discoveryengine/v1/internal/site_search_engine_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SiteSearchEngineServiceTracingStub::SiteSearchEngineServiceTracingStub(
    std::shared_ptr<SiteSearchEngineServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
SiteSearchEngineServiceTracingStub::GetSiteSearchEngine(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "GetSiteSearchEngine");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetSiteSearchEngine(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncCreateTargetSite(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "CreateTargetSite");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateTargetSite(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::CreateTargetSite(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "CreateTargetSite");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateTargetSite(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncBatchCreateTargetSites(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "BatchCreateTargetSites");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncBatchCreateTargetSites(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::BatchCreateTargetSites(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "BatchCreateTargetSites");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->BatchCreateTargetSites(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceTracingStub::GetTargetSite(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "GetTargetSite");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTargetSite(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncUpdateTargetSite(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "UpdateTargetSite");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateTargetSite(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::UpdateTargetSite(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "UpdateTargetSite");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateTargetSite(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncDeleteTargetSite(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "DeleteTargetSite");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteTargetSite(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::DeleteTargetSite(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "DeleteTargetSite");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteTargetSite(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::ListTargetSitesResponse>
SiteSearchEngineServiceTracingStub::ListTargetSites(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::ListTargetSitesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "ListTargetSites");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTargetSites(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncEnableAdvancedSiteSearch(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "EnableAdvancedSiteSearch");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncEnableAdvancedSiteSearch(cq, context,
                                                 std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::EnableAdvancedSiteSearch(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "EnableAdvancedSiteSearch");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->EnableAdvancedSiteSearch(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncDisableAdvancedSiteSearch(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "DisableAdvancedSiteSearch");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDisableAdvancedSiteSearch(cq, context,
                                                  std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::DisableAdvancedSiteSearch(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "DisableAdvancedSiteSearch");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DisableAdvancedSiteSearch(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncRecrawlUris(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService", "RecrawlUris");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRecrawlUris(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::RecrawlUris(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService", "RecrawlUris");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RecrawlUris(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncBatchVerifyTargetSites(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "BatchVerifyTargetSites");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncBatchVerifyTargetSites(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::BatchVerifyTargetSites(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "BatchVerifyTargetSites");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->BatchVerifyTargetSites(context, options, request));
}

StatusOr<
    google::cloud::discoveryengine::v1::FetchDomainVerificationStatusResponse>
SiteSearchEngineServiceTracingStub::FetchDomainVerificationStatus(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::
        FetchDomainVerificationStatusRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "FetchDomainVerificationStatus");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->FetchDomainVerificationStatus(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
SiteSearchEngineServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status SiteSearchEngineServiceTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.SiteSearchEngineService",
      "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> SiteSearchEngineServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<SiteSearchEngineServiceStub>
MakeSiteSearchEngineServiceTracingStub(
    std::shared_ptr<SiteSearchEngineServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<SiteSearchEngineServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
