// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/project_service.proto

#include "google/cloud/discoveryengine/v1/internal/project_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ProjectServiceTracingConnection::ProjectServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::ProjectServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::discoveryengine::v1::Project>>
ProjectServiceTracingConnection::ProvisionProject(
    google::cloud::discoveryengine::v1::ProvisionProjectRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::ProjectServiceConnection::ProvisionProject");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ProvisionProject(request));
}

StatusOr<google::longrunning::Operation>
ProjectServiceTracingConnection::ProvisionProject(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::ProvisionProjectRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::ProjectServiceConnection::ProvisionProject");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ProvisionProject(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::Project>>
ProjectServiceTracingConnection::ProvisionProject(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::ProjectServiceConnection::ProvisionProject");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ProvisionProject(operation));
}

StreamRange<google::longrunning::Operation>
ProjectServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::ProjectServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
ProjectServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::ProjectServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status ProjectServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::ProjectServiceConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<discoveryengine_v1::ProjectServiceConnection>
MakeProjectServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::ProjectServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ProjectServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
