// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/data_store_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_DATA_STORE_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_DATA_STORE_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/discoveryengine/v1/data_store_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DataStoreServiceStub {
 public:
  virtual ~DataStoreServiceStub() = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateDataStore(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::CreateDataStoreRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateDataStore(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::CreateDataStoreRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::discoveryengine::v1::DataStore> GetDataStore(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetDataStoreRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::discoveryengine::v1::ListDataStoresResponse>
  ListDataStores(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::ListDataStoresRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteDataStore(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::DeleteDataStoreRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteDataStore(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::DeleteDataStoreRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::discoveryengine::v1::DataStore>
  UpdateDataStore(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::UpdateDataStoreRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultDataStoreServiceStub : public DataStoreServiceStub {
 public:
  DefaultDataStoreServiceStub(
      std::unique_ptr<
          google::cloud::discoveryengine::v1::DataStoreService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)),
        operations_stub_(std::move(operations_stub)),
        operations_(std::move(operations)) {}

  future<StatusOr<google::longrunning::Operation>> AsyncCreateDataStore(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateDataStore(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::DataStore> GetDataStore(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetDataStoreRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::ListDataStoresResponse>
  ListDataStores(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::ListDataStoresRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteDataStore(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteDataStore(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::DataStore> UpdateDataStore(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::UpdateDataStoreRequest const& request)
      override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<
      google::cloud::discoveryengine::v1::DataStoreService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface>
      operations_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_DATA_STORE_STUB_H
