// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/conversational_search_service.proto

#include "google/cloud/discoveryengine/v1/internal/conversational_search_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConversationalSearchServiceTracingStub::ConversationalSearchServiceTracingStub(
    std::shared_ptr<ConversationalSearchServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::discoveryengine::v1::ConverseConversationResponse>
ConversationalSearchServiceTracingStub::ConverseConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::ConverseConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "ConverseConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ConverseConversation(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceTracingStub::CreateConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::CreateConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "CreateConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateConversation(context, options, request));
}

Status ConversationalSearchServiceTracingStub::DeleteConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::DeleteConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "DeleteConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteConversation(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceTracingStub::UpdateConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::UpdateConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "UpdateConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateConversation(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceTracingStub::GetConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetConversationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "GetConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetConversation(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::ListConversationsResponse>
ConversationalSearchServiceTracingStub::ListConversations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::ListConversationsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "ListConversations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListConversations(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::AnswerQueryResponse>
ConversationalSearchServiceTracingStub::AnswerQuery(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::AnswerQueryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "AnswerQuery");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->AnswerQuery(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::Answer>
ConversationalSearchServiceTracingStub::GetAnswer(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetAnswerRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "GetAnswer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAnswer(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceTracingStub::CreateSession(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::CreateSessionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "CreateSession");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateSession(context, options, request));
}

Status ConversationalSearchServiceTracingStub::DeleteSession(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::DeleteSessionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "DeleteSession");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteSession(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceTracingStub::UpdateSession(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::UpdateSessionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "UpdateSession");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateSession(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceTracingStub::GetSession(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetSessionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "GetSession");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSession(context, options, request));
}

StatusOr<google::cloud::discoveryengine::v1::ListSessionsResponse>
ConversationalSearchServiceTracingStub::ListSessions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::ListSessionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "ListSessions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSessions(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
ConversationalSearchServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
ConversationalSearchServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status ConversationalSearchServiceTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.discoveryengine.v1.ConversationalSearchService",
      "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ConversationalSearchServiceStub>
MakeConversationalSearchServiceTracingStub(
    std::shared_ptr<ConversationalSearchServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ConversationalSearchServiceTracingStub>(
      std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
