// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/control_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_CONTROL_TRACING_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_CONTROL_TRACING_STUB_H

#include "google/cloud/discoveryengine/v1/internal/control_stub.h"
#include "google/cloud/internal/trace_propagator.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ControlServiceTracingStub : public ControlServiceStub {
 public:
  ~ControlServiceTracingStub() override = default;

  explicit ControlServiceTracingStub(std::shared_ptr<ControlServiceStub> child);

  StatusOr<google::cloud::discoveryengine::v1::Control> CreateControl(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::CreateControlRequest const& request)
      override;

  Status DeleteControl(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::DeleteControlRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Control> UpdateControl(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::UpdateControlRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Control> GetControl(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetControlRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::ListControlsResponse>
  ListControls(grpc::ClientContext& context, Options const& options,
               google::cloud::discoveryengine::v1::ListControlsRequest const&
                   request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<ControlServiceStub> child_;
  std::shared_ptr<opentelemetry::context::propagation::TextMapPropagator>
      propagator_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Applies the tracing decorator to the given stub.
 *
 * The stub is only decorated if the library has been compiled with
 * OpenTelemetry.
 */
std::shared_ptr<ControlServiceStub> MakeControlServiceTracingStub(
    std::shared_ptr<ControlServiceStub> stub);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_CONTROL_TRACING_STUB_H
