// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/control_service.proto

#include "google/cloud/discoveryengine/v1/internal/control_auth_decorator.h"
#include <google/cloud/discoveryengine/v1/control_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ControlServiceAuth::ControlServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<ControlServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::discoveryengine::v1::Control>
ControlServiceAuth::CreateControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::CreateControlRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateControl(context, options, request);
}

Status ControlServiceAuth::DeleteControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::DeleteControlRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteControl(context, options, request);
}

StatusOr<google::cloud::discoveryengine::v1::Control>
ControlServiceAuth::UpdateControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::UpdateControlRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateControl(context, options, request);
}

StatusOr<google::cloud::discoveryengine::v1::Control>
ControlServiceAuth::GetControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetControlRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetControl(context, options, request);
}

StatusOr<google::cloud::discoveryengine::v1::ListControlsResponse>
ControlServiceAuth::ListControls(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::ListControlsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListControls(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
ControlServiceAuth::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> ControlServiceAuth::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOperation(context, options, request);
}

Status ControlServiceAuth::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CancelOperation(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
