// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/document_service.proto

#include "google/cloud/discoveryengine/v1/document_connection.h"
#include "google/cloud/discoveryengine/v1/document_options.h"
#include "google/cloud/discoveryengine/v1/internal/document_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/document_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/document_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/document_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentServiceConnection::~DocumentServiceConnection() = default;

StatusOr<google::cloud::discoveryengine::v1::Document>
DocumentServiceConnection::GetDocument(
    google::cloud::discoveryengine::v1::GetDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::discoveryengine::v1::Document>
DocumentServiceConnection::ListDocuments(
    google::cloud::discoveryengine::v1::
        ListDocumentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::Document>>();
}

StatusOr<google::cloud::discoveryengine::v1::Document>
DocumentServiceConnection::CreateDocument(
    google::cloud::discoveryengine::v1::CreateDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::discoveryengine::v1::Document>
DocumentServiceConnection::UpdateDocument(
    google::cloud::discoveryengine::v1::UpdateDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DocumentServiceConnection::DeleteDocument(
    google::cloud::discoveryengine::v1::DeleteDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::discoveryengine::v1::ImportDocumentsResponse>>
DocumentServiceConnection::ImportDocuments(
    google::cloud::discoveryengine::v1::ImportDocumentsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::ImportDocumentsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DocumentServiceConnection::ImportDocuments(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::ImportDocumentsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::ImportDocumentsResponse>>
DocumentServiceConnection::ImportDocuments(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::ImportDocumentsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::PurgeDocumentsResponse>>
DocumentServiceConnection::PurgeDocuments(
    google::cloud::discoveryengine::v1::PurgeDocumentsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::PurgeDocumentsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DocumentServiceConnection::PurgeDocuments(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::PurgeDocumentsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::PurgeDocumentsResponse>>
DocumentServiceConnection::PurgeDocuments(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::PurgeDocumentsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::discoveryengine::v1::BatchGetDocumentsMetadataResponse>
DocumentServiceConnection::BatchGetDocumentsMetadata(
    google::cloud::discoveryengine::v1::
        BatchGetDocumentsMetadataRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
DocumentServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
DocumentServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DocumentServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DocumentServiceConnection> MakeDocumentServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DocumentServicePolicyOptionList>(options,
                                                                  __func__);
  options = discoveryengine_v1_internal::DocumentServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = discoveryengine_v1_internal::CreateDefaultDocumentServiceStub(
      std::move(auth), options);
  return discoveryengine_v1_internal::MakeDocumentServiceTracingConnection(
      std::make_shared<
          discoveryengine_v1_internal::DocumentServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
