// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/data_store_service.proto

#include "google/cloud/discoveryengine/v1/data_store_connection.h"
#include "google/cloud/discoveryengine/v1/data_store_options.h"
#include "google/cloud/discoveryengine/v1/internal/data_store_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/data_store_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/data_store_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/data_store_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataStoreServiceConnection::~DataStoreServiceConnection() = default;

future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
DataStoreServiceConnection::CreateDataStore(
    google::cloud::discoveryengine::v1::CreateDataStoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DataStore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataStoreServiceConnection::CreateDataStore(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateDataStoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
DataStoreServiceConnection::CreateDataStore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DataStore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceConnection::GetDataStore(
    google::cloud::discoveryengine::v1::GetDataStoreRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceConnection::ListDataStores(
    google::cloud::discoveryengine::v1::
        ListDataStoresRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::DataStore>>();
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
DataStoreServiceConnection::DeleteDataStore(
    google::cloud::discoveryengine::v1::DeleteDataStoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataStoreServiceConnection::DeleteDataStore(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteDataStoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
DataStoreServiceConnection::DeleteDataStore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceConnection::UpdateDataStore(
    google::cloud::discoveryengine::v1::UpdateDataStoreRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
DataStoreServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
DataStoreServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataStoreServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DataStoreServiceConnection> MakeDataStoreServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DataStoreServicePolicyOptionList>(options,
                                                                   __func__);
  options = discoveryengine_v1_internal::DataStoreServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = discoveryengine_v1_internal::CreateDefaultDataStoreServiceStub(
      std::move(auth), options);
  return discoveryengine_v1_internal::MakeDataStoreServiceTracingConnection(
      std::make_shared<
          discoveryengine_v1_internal::DataStoreServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
