// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/conversational_search_service.proto

#include "google/cloud/discoveryengine/v1/conversational_search_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationalSearchServiceClient::ConversationalSearchServiceClient(
    std::shared_ptr<ConversationalSearchServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ConversationalSearchServiceClient::~ConversationalSearchServiceClient() =
    default;

StatusOr<google::cloud::discoveryengine::v1::ConverseConversationResponse>
ConversationalSearchServiceClient::ConverseConversation(
    std::string const& name,
    google::cloud::discoveryengine::v1::TextInput const& query, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::ConverseConversationRequest request;
  request.set_name(name);
  *request.mutable_query() = query;
  return connection_->ConverseConversation(request);
}

StatusOr<google::cloud::discoveryengine::v1::ConverseConversationResponse>
ConversationalSearchServiceClient::ConverseConversation(
    google::cloud::discoveryengine::v1::ConverseConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConverseConversation(request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::CreateConversation(
    std::string const& parent,
    google::cloud::discoveryengine::v1::Conversation const& conversation,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::CreateConversationRequest request;
  request.set_parent(parent);
  *request.mutable_conversation() = conversation;
  return connection_->CreateConversation(request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::CreateConversation(
    google::cloud::discoveryengine::v1::CreateConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversation(request);
}

Status ConversationalSearchServiceClient::DeleteConversation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::DeleteConversationRequest request;
  request.set_name(name);
  return connection_->DeleteConversation(request);
}

Status ConversationalSearchServiceClient::DeleteConversation(
    google::cloud::discoveryengine::v1::DeleteConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConversation(request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::UpdateConversation(
    google::cloud::discoveryengine::v1::Conversation const& conversation,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::UpdateConversationRequest request;
  *request.mutable_conversation() = conversation;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateConversation(request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::UpdateConversation(
    google::cloud::discoveryengine::v1::UpdateConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConversation(request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::GetConversation(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::GetConversationRequest request;
  request.set_name(name);
  return connection_->GetConversation(request);
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::GetConversation(
    google::cloud::discoveryengine::v1::GetConversationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConversation(request);
}

StreamRange<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::ListConversations(std::string const& parent,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::ListConversationsRequest request;
  request.set_parent(parent);
  return connection_->ListConversations(request);
}

StreamRange<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceClient::ListConversations(
    google::cloud::discoveryengine::v1::ListConversationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConversations(std::move(request));
}

StatusOr<google::cloud::discoveryengine::v1::AnswerQueryResponse>
ConversationalSearchServiceClient::AnswerQuery(
    google::cloud::discoveryengine::v1::AnswerQueryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AnswerQuery(request);
}

StatusOr<google::cloud::discoveryengine::v1::Answer>
ConversationalSearchServiceClient::GetAnswer(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::GetAnswerRequest request;
  request.set_name(name);
  return connection_->GetAnswer(request);
}

StatusOr<google::cloud::discoveryengine::v1::Answer>
ConversationalSearchServiceClient::GetAnswer(
    google::cloud::discoveryengine::v1::GetAnswerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAnswer(request);
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::CreateSession(
    std::string const& parent,
    google::cloud::discoveryengine::v1::Session const& session, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::CreateSessionRequest request;
  request.set_parent(parent);
  *request.mutable_session() = session;
  return connection_->CreateSession(request);
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::CreateSession(
    google::cloud::discoveryengine::v1::CreateSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSession(request);
}

Status ConversationalSearchServiceClient::DeleteSession(std::string const& name,
                                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::DeleteSessionRequest request;
  request.set_name(name);
  return connection_->DeleteSession(request);
}

Status ConversationalSearchServiceClient::DeleteSession(
    google::cloud::discoveryengine::v1::DeleteSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSession(request);
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::UpdateSession(
    google::cloud::discoveryengine::v1::Session const& session,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::UpdateSessionRequest request;
  *request.mutable_session() = session;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSession(request);
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::UpdateSession(
    google::cloud::discoveryengine::v1::UpdateSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSession(request);
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::GetSession(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::GetSessionRequest request;
  request.set_name(name);
  return connection_->GetSession(request);
}

StatusOr<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::GetSession(
    google::cloud::discoveryengine::v1::GetSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSession(request);
}

StreamRange<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::ListSessions(std::string const& parent,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::ListSessionsRequest request;
  request.set_parent(parent);
  return connection_->ListSessions(request);
}

StreamRange<google::cloud::discoveryengine::v1::Session>
ConversationalSearchServiceClient::ListSessions(
    google::cloud::discoveryengine::v1::ListSessionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSessions(std::move(request));
}

StreamRange<google::longrunning::Operation>
ConversationalSearchServiceClient::ListOperations(std::string const& name,
                                                  std::string const& filter,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
ConversationalSearchServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
ConversationalSearchServiceClient::GetOperation(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
ConversationalSearchServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status ConversationalSearchServiceClient::CancelOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status ConversationalSearchServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
