// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/control_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_CONTROL_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_CONTROL_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/discoveryengine/v1/control_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ControlServiceConnectionIdempotencyPolicy {
 public:
  virtual ~ControlServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ControlServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateControl(
      google::cloud::discoveryengine::v1::CreateControlRequest const& request);

  virtual google::cloud::Idempotency DeleteControl(
      google::cloud::discoveryengine::v1::DeleteControlRequest const& request);

  virtual google::cloud::Idempotency UpdateControl(
      google::cloud::discoveryengine::v1::UpdateControlRequest const& request);

  virtual google::cloud::Idempotency GetControl(
      google::cloud::discoveryengine::v1::GetControlRequest const& request);

  virtual google::cloud::Idempotency ListControls(
      google::cloud::discoveryengine::v1::ListControlsRequest request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

std::unique_ptr<ControlServiceConnectionIdempotencyPolicy>
MakeDefaultControlServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_CONTROL_CONNECTION_IDEMPOTENCY_POLICY_H
