// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/completion_service.proto

#include "google/cloud/discoveryengine/v1/completion_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CompletionServiceConnectionIdempotencyPolicy::
    ~CompletionServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<CompletionServiceConnectionIdempotencyPolicy>
CompletionServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CompletionServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency CompletionServiceConnectionIdempotencyPolicy::CompleteQuery(
    google::cloud::discoveryengine::v1::CompleteQueryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
CompletionServiceConnectionIdempotencyPolicy::ImportSuggestionDenyListEntries(
    google::cloud::discoveryengine::v1::
        ImportSuggestionDenyListEntriesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CompletionServiceConnectionIdempotencyPolicy::PurgeSuggestionDenyListEntries(
    google::cloud::discoveryengine::v1::
        PurgeSuggestionDenyListEntriesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CompletionServiceConnectionIdempotencyPolicy::ImportCompletionSuggestions(
    google::cloud::discoveryengine::v1::
        ImportCompletionSuggestionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CompletionServiceConnectionIdempotencyPolicy::PurgeCompletionSuggestions(
    google::cloud::discoveryengine::v1::
        PurgeCompletionSuggestionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CompletionServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CompletionServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CompletionServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CompletionServiceConnectionIdempotencyPolicy>
MakeDefaultCompletionServiceConnectionIdempotencyPolicy() {
  return std::make_unique<CompletionServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
