// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/participant.proto

#include "google/cloud/dialogflow_es/participants_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ParticipantsConnectionIdempotencyPolicy::
    ~ParticipantsConnectionIdempotencyPolicy() = default;

std::unique_ptr<ParticipantsConnectionIdempotencyPolicy>
ParticipantsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ParticipantsConnectionIdempotencyPolicy>(*this);
}

Idempotency ParticipantsConnectionIdempotencyPolicy::CreateParticipant(
    google::cloud::dialogflow::v2::CreateParticipantRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::GetParticipant(
    google::cloud::dialogflow::v2::GetParticipantRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::ListParticipants(
    google::cloud::dialogflow::v2::ListParticipantsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::UpdateParticipant(
    google::cloud::dialogflow::v2::UpdateParticipantRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::AnalyzeContent(
    google::cloud::dialogflow::v2::AnalyzeContentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::SuggestArticles(
    google::cloud::dialogflow::v2::SuggestArticlesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::SuggestFaqAnswers(
    google::cloud::dialogflow::v2::SuggestFaqAnswersRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::SuggestSmartReplies(
    google::cloud::dialogflow::v2::SuggestSmartRepliesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::SuggestKnowledgeAssist(
    google::cloud::dialogflow::v2::SuggestKnowledgeAssistRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ParticipantsConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ParticipantsConnectionIdempotencyPolicy>
MakeDefaultParticipantsConnectionIdempotencyPolicy() {
  return std::make_unique<ParticipantsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
