// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/document.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_DOCUMENTS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_DOCUMENTS_CONNECTION_IMPL_H

#include "google/cloud/dialogflow_es/documents_connection.h"
#include "google/cloud/dialogflow_es/documents_connection_idempotency_policy.h"
#include "google/cloud/dialogflow_es/documents_options.h"
#include "google/cloud/dialogflow_es/internal/documents_retry_traits.h"
#include "google/cloud/dialogflow_es/internal/documents_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DocumentsConnectionImpl : public dialogflow_es::DocumentsConnection {
 public:
  ~DocumentsConnectionImpl() override = default;

  DocumentsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<dialogflow_es_internal::DocumentsStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::dialogflow::v2::Document> ListDocuments(
      google::cloud::dialogflow::v2::ListDocumentsRequest request) override;

  StatusOr<google::cloud::dialogflow::v2::Document> GetDocument(
      google::cloud::dialogflow::v2::GetDocumentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> CreateDocument(
      google::cloud::dialogflow::v2::CreateDocumentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::CreateDocumentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> CreateDocument(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dialogflow::v2::ImportDocumentsResponse>>
  ImportDocuments(google::cloud::dialogflow::v2::ImportDocumentsRequest const&
                      request) override;

  StatusOr<google::longrunning::Operation> ImportDocuments(
      NoAwaitTag,
      google::cloud::dialogflow::v2::ImportDocumentsRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::v2::ImportDocumentsResponse>>
  ImportDocuments(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dialogflow::v2::KnowledgeOperationMetadata>>
  DeleteDocument(google::cloud::dialogflow::v2::DeleteDocumentRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DeleteDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::DeleteDocumentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::v2::KnowledgeOperationMetadata>>
  DeleteDocument(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> UpdateDocument(
      google::cloud::dialogflow::v2::UpdateDocumentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::UpdateDocumentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> UpdateDocument(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> ReloadDocument(
      google::cloud::dialogflow::v2::ReloadDocumentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ReloadDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::ReloadDocumentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> ReloadDocument(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> ExportDocument(
      google::cloud::dialogflow::v2::ExportDocumentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ExportDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::ExportDocumentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::v2::Document>> ExportDocument(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<dialogflow_es_internal::DocumentsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_DOCUMENTS_CONNECTION_IMPL_H
