// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/environment.proto

#include "google/cloud/dialogflow_es/environments_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

EnvironmentsConnectionIdempotencyPolicy::
    ~EnvironmentsConnectionIdempotencyPolicy() = default;

std::unique_ptr<EnvironmentsConnectionIdempotencyPolicy>
EnvironmentsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<EnvironmentsConnectionIdempotencyPolicy>(*this);
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::ListEnvironments(
    google::cloud::dialogflow::v2::ListEnvironmentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::GetEnvironment(
    google::cloud::dialogflow::v2::GetEnvironmentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::CreateEnvironment(
    google::cloud::dialogflow::v2::CreateEnvironmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::UpdateEnvironment(
    google::cloud::dialogflow::v2::UpdateEnvironmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::DeleteEnvironment(
    google::cloud::dialogflow::v2::DeleteEnvironmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::GetEnvironmentHistory(
    google::cloud::dialogflow::v2::GetEnvironmentHistoryRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<EnvironmentsConnectionIdempotencyPolicy>
MakeDefaultEnvironmentsConnectionIdempotencyPolicy() {
  return std::make_unique<EnvironmentsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
