// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/encryption_spec.proto

#include "google/cloud/dialogflow_es/encryption_spec_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

EncryptionSpecServiceConnectionIdempotencyPolicy::
    ~EncryptionSpecServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<EncryptionSpecServiceConnectionIdempotencyPolicy>
EncryptionSpecServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<EncryptionSpecServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency EncryptionSpecServiceConnectionIdempotencyPolicy::GetEncryptionSpec(
    google::cloud::dialogflow::v2::GetEncryptionSpecRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
EncryptionSpecServiceConnectionIdempotencyPolicy::InitializeEncryptionSpec(
    google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EncryptionSpecServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EncryptionSpecServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EncryptionSpecServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EncryptionSpecServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EncryptionSpecServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<EncryptionSpecServiceConnectionIdempotencyPolicy>
MakeDefaultEncryptionSpecServiceConnectionIdempotencyPolicy() {
  return std::make_unique<EncryptionSpecServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
