// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/encryption_spec.proto

#include "google/cloud/dialogflow_es/encryption_spec_connection.h"
#include "google/cloud/dialogflow_es/encryption_spec_options.h"
#include "google/cloud/dialogflow_es/internal/encryption_spec_connection_impl.h"
#include "google/cloud/dialogflow_es/internal/encryption_spec_option_defaults.h"
#include "google/cloud/dialogflow_es/internal/encryption_spec_stub_factory.h"
#include "google/cloud/dialogflow_es/internal/encryption_spec_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EncryptionSpecServiceConnection::~EncryptionSpecServiceConnection() = default;

StatusOr<google::cloud::dialogflow::v2::EncryptionSpec>
EncryptionSpecServiceConnection::GetEncryptionSpec(
    google::cloud::dialogflow::v2::GetEncryptionSpecRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<
    StatusOr<google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>
EncryptionSpecServiceConnection::InitializeEncryptionSpec(
    google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
EncryptionSpecServiceConnection::InitializeEncryptionSpec(
    NoAwaitTag,
    google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<
    StatusOr<google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>
EncryptionSpecServiceConnection::InitializeEncryptionSpec(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
EncryptionSpecServiceConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
EncryptionSpecServiceConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
EncryptionSpecServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
EncryptionSpecServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status EncryptionSpecServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<EncryptionSpecServiceConnection>
MakeEncryptionSpecServiceConnection(std::string const& location,
                                    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 EncryptionSpecServicePolicyOptionList>(
      options, __func__);
  options = dialogflow_es_internal::EncryptionSpecServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dialogflow_es_internal::CreateDefaultEncryptionSpecServiceStub(
      std::move(auth), options);
  return dialogflow_es_internal::MakeEncryptionSpecServiceTracingConnection(
      std::make_shared<
          dialogflow_es_internal::EncryptionSpecServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<EncryptionSpecServiceConnection>
MakeEncryptionSpecServiceConnection(Options options) {
  return MakeEncryptionSpecServiceConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
