// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/encryption_spec.proto

#include "google/cloud/dialogflow_es/encryption_spec_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EncryptionSpecServiceClient::EncryptionSpecServiceClient(
    std::shared_ptr<EncryptionSpecServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EncryptionSpecServiceClient::~EncryptionSpecServiceClient() = default;

StatusOr<google::cloud::dialogflow::v2::EncryptionSpec>
EncryptionSpecServiceClient::GetEncryptionSpec(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetEncryptionSpecRequest request;
  request.set_name(name);
  return connection_->GetEncryptionSpec(request);
}

StatusOr<google::cloud::dialogflow::v2::EncryptionSpec>
EncryptionSpecServiceClient::GetEncryptionSpec(
    google::cloud::dialogflow::v2::GetEncryptionSpecRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEncryptionSpec(request);
}

future<
    StatusOr<google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>
EncryptionSpecServiceClient::InitializeEncryptionSpec(
    google::cloud::dialogflow::v2::EncryptionSpec const& encryption_spec,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest request;
  *request.mutable_encryption_spec() = encryption_spec;
  return connection_->InitializeEncryptionSpec(request);
}

StatusOr<google::longrunning::Operation>
EncryptionSpecServiceClient::InitializeEncryptionSpec(
    NoAwaitTag,
    google::cloud::dialogflow::v2::EncryptionSpec const& encryption_spec,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest request;
  *request.mutable_encryption_spec() = encryption_spec;
  return connection_->InitializeEncryptionSpec(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>
EncryptionSpecServiceClient::InitializeEncryptionSpec(
    google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InitializeEncryptionSpec(request);
}

StatusOr<google::longrunning::Operation>
EncryptionSpecServiceClient::InitializeEncryptionSpec(
    NoAwaitTag,
    google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InitializeEncryptionSpec(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>
EncryptionSpecServiceClient::InitializeEncryptionSpec(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InitializeEncryptionSpec(operation);
}

StreamRange<google::cloud::location::Location>
EncryptionSpecServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
EncryptionSpecServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation>
EncryptionSpecServiceClient::ListOperations(std::string const& name,
                                            std::string const& filter,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
EncryptionSpecServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
EncryptionSpecServiceClient::GetOperation(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
EncryptionSpecServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status EncryptionSpecServiceClient::CancelOperation(std::string const& name,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status EncryptionSpecServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
