// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_profile.proto

#include "google/cloud/dialogflow_es/conversation_profiles_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationProfilesClient::ConversationProfilesClient(
    std::shared_ptr<ConversationProfilesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ConversationProfilesClient::~ConversationProfilesClient() = default;

StreamRange<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::ListConversationProfiles(std::string const& parent,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListConversationProfilesRequest request;
  request.set_parent(parent);
  return connection_->ListConversationProfiles(request);
}

StreamRange<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::ListConversationProfiles(
    google::cloud::dialogflow::v2::ListConversationProfilesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConversationProfiles(std::move(request));
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::GetConversationProfile(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetConversationProfileRequest request;
  request.set_name(name);
  return connection_->GetConversationProfile(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::GetConversationProfile(
    google::cloud::dialogflow::v2::GetConversationProfileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConversationProfile(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::CreateConversationProfile(
    std::string const& parent,
    google::cloud::dialogflow::v2::ConversationProfile const&
        conversation_profile,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateConversationProfileRequest request;
  request.set_parent(parent);
  *request.mutable_conversation_profile() = conversation_profile;
  return connection_->CreateConversationProfile(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::CreateConversationProfile(
    google::cloud::dialogflow::v2::CreateConversationProfileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationProfile(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::UpdateConversationProfile(
    google::cloud::dialogflow::v2::ConversationProfile const&
        conversation_profile,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::UpdateConversationProfileRequest request;
  *request.mutable_conversation_profile() = conversation_profile;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateConversationProfile(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesClient::UpdateConversationProfile(
    google::cloud::dialogflow::v2::UpdateConversationProfileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConversationProfile(request);
}

Status ConversationProfilesClient::DeleteConversationProfile(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::DeleteConversationProfileRequest request;
  request.set_name(name);
  return connection_->DeleteConversationProfile(request);
}

Status ConversationProfilesClient::DeleteConversationProfile(
    google::cloud::dialogflow::v2::DeleteConversationProfileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConversationProfile(request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::SetSuggestionFeatureConfig(
    std::string const& conversation_profile, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  return connection_->SetSuggestionFeatureConfig(request);
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::SetSuggestionFeatureConfig(
    NoAwaitTag, std::string const& conversation_profile, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  return connection_->SetSuggestionFeatureConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::SetSuggestionFeatureConfig(
    std::string const& conversation_profile,
    google::cloud::dialogflow::v2::Participant::Role participant_role,
    google::cloud::dialogflow::v2::HumanAgentAssistantConfig::
        SuggestionFeatureConfig const& suggestion_feature_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  request.set_participant_role(participant_role);
  *request.mutable_suggestion_feature_config() = suggestion_feature_config;
  return connection_->SetSuggestionFeatureConfig(request);
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::SetSuggestionFeatureConfig(
    NoAwaitTag, std::string const& conversation_profile,
    google::cloud::dialogflow::v2::Participant::Role participant_role,
    google::cloud::dialogflow::v2::HumanAgentAssistantConfig::
        SuggestionFeatureConfig const& suggestion_feature_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  request.set_participant_role(participant_role);
  *request.mutable_suggestion_feature_config() = suggestion_feature_config;
  return connection_->SetSuggestionFeatureConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::SetSuggestionFeatureConfig(
    google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSuggestionFeatureConfig(request);
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::SetSuggestionFeatureConfig(
    NoAwaitTag,
    google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSuggestionFeatureConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::SetSuggestionFeatureConfig(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSuggestionFeatureConfig(operation);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::ClearSuggestionFeatureConfig(
    std::string const& conversation_profile, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  return connection_->ClearSuggestionFeatureConfig(request);
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::ClearSuggestionFeatureConfig(
    NoAwaitTag, std::string const& conversation_profile, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  return connection_->ClearSuggestionFeatureConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::ClearSuggestionFeatureConfig(
    std::string const& conversation_profile,
    google::cloud::dialogflow::v2::Participant::Role participant_role,
    google::cloud::dialogflow::v2::SuggestionFeature::Type
        suggestion_feature_type,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  request.set_participant_role(participant_role);
  request.set_suggestion_feature_type(suggestion_feature_type);
  return connection_->ClearSuggestionFeatureConfig(request);
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::ClearSuggestionFeatureConfig(
    NoAwaitTag, std::string const& conversation_profile,
    google::cloud::dialogflow::v2::Participant::Role participant_role,
    google::cloud::dialogflow::v2::SuggestionFeature::Type
        suggestion_feature_type,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest request;
  request.set_conversation_profile(conversation_profile);
  request.set_participant_role(participant_role);
  request.set_suggestion_feature_type(suggestion_feature_type);
  return connection_->ClearSuggestionFeatureConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::ClearSuggestionFeatureConfig(
    google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ClearSuggestionFeatureConfig(request);
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::ClearSuggestionFeatureConfig(
    NoAwaitTag,
    google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ClearSuggestionFeatureConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesClient::ClearSuggestionFeatureConfig(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ClearSuggestionFeatureConfig(operation);
}

StreamRange<google::cloud::location::Location>
ConversationProfilesClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
ConversationProfilesClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation>
ConversationProfilesClient::ListOperations(std::string const& name,
                                           std::string const& filter,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
ConversationProfilesClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::GetOperation(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
ConversationProfilesClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status ConversationProfilesClient::CancelOperation(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status ConversationProfilesClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
