// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_model.proto

#include "google/cloud/dialogflow_es/conversation_models_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ConversationModelsConnectionIdempotencyPolicy::
    ~ConversationModelsConnectionIdempotencyPolicy() = default;

std::unique_ptr<ConversationModelsConnectionIdempotencyPolicy>
ConversationModelsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ConversationModelsConnectionIdempotencyPolicy>(*this);
}

Idempotency
ConversationModelsConnectionIdempotencyPolicy::CreateConversationModel(
    google::cloud::dialogflow::v2::CreateConversationModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConversationModelsConnectionIdempotencyPolicy::GetConversationModel(
    google::cloud::dialogflow::v2::GetConversationModelRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
ConversationModelsConnectionIdempotencyPolicy::ListConversationModels(
    google::cloud::dialogflow::v2::ListConversationModelsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
ConversationModelsConnectionIdempotencyPolicy::DeleteConversationModel(
    google::cloud::dialogflow::v2::DeleteConversationModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ConversationModelsConnectionIdempotencyPolicy::DeployConversationModel(
    google::cloud::dialogflow::v2::DeployConversationModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ConversationModelsConnectionIdempotencyPolicy::UndeployConversationModel(
    google::cloud::dialogflow::v2::UndeployConversationModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ConversationModelsConnectionIdempotencyPolicy::GetConversationModelEvaluation(
    google::cloud::dialogflow::v2::
        GetConversationModelEvaluationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
ConversationModelsConnectionIdempotencyPolicy::ListConversationModelEvaluations(
    google::cloud::dialogflow::v2::
        ListConversationModelEvaluationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ConversationModelsConnectionIdempotencyPolicy::
    CreateConversationModelEvaluation(
        google::cloud::dialogflow::v2::
            CreateConversationModelEvaluationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConversationModelsConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ConversationModelsConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ConversationModelsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ConversationModelsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ConversationModelsConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ConversationModelsConnectionIdempotencyPolicy>
MakeDefaultConversationModelsConnectionIdempotencyPolicy() {
  return std::make_unique<ConversationModelsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
