// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/agent.proto

#include "google/cloud/dialogflow_es/agents_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AgentsConnectionIdempotencyPolicy::~AgentsConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<AgentsConnectionIdempotencyPolicy>
AgentsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AgentsConnectionIdempotencyPolicy>(*this);
}

Idempotency AgentsConnectionIdempotencyPolicy::GetAgent(
    google::cloud::dialogflow::v2::GetAgentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::SetAgent(
    google::cloud::dialogflow::v2::SetAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::DeleteAgent(
    google::cloud::dialogflow::v2::DeleteAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::SearchAgents(
    google::cloud::dialogflow::v2::SearchAgentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::TrainAgent(
    google::cloud::dialogflow::v2::TrainAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::ExportAgent(
    google::cloud::dialogflow::v2::ExportAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::ImportAgent(
    google::cloud::dialogflow::v2::ImportAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::RestoreAgent(
    google::cloud::dialogflow::v2::RestoreAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::GetValidationResult(
    google::cloud::dialogflow::v2::GetValidationResultRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<AgentsConnectionIdempotencyPolicy>
MakeDefaultAgentsConnectionIdempotencyPolicy() {
  return std::make_unique<AgentsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
