// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/webhook.proto

#include "google/cloud/dialogflow_cx/webhooks_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

WebhooksConnectionIdempotencyPolicy::~WebhooksConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<WebhooksConnectionIdempotencyPolicy>
WebhooksConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<WebhooksConnectionIdempotencyPolicy>(*this);
}

Idempotency WebhooksConnectionIdempotencyPolicy::ListWebhooks(
    google::cloud::dialogflow::cx::v3::ListWebhooksRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::GetWebhook(
    google::cloud::dialogflow::cx::v3::GetWebhookRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::CreateWebhook(
    google::cloud::dialogflow::cx::v3::CreateWebhookRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::UpdateWebhook(
    google::cloud::dialogflow::cx::v3::UpdateWebhookRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::DeleteWebhook(
    google::cloud::dialogflow::cx::v3::DeleteWebhookRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebhooksConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<WebhooksConnectionIdempotencyPolicy>
MakeDefaultWebhooksConnectionIdempotencyPolicy() {
  return std::make_unique<WebhooksConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
