// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/transition_route_group.proto

#include "google/cloud/dialogflow_cx/transition_route_groups_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TransitionRouteGroupsClient::TransitionRouteGroupsClient(
    std::shared_ptr<TransitionRouteGroupsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TransitionRouteGroupsClient::~TransitionRouteGroupsClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::ListTransitionRouteGroups(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListTransitionRouteGroupsRequest request;
  request.set_parent(parent);
  return connection_->ListTransitionRouteGroups(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::ListTransitionRouteGroups(
    google::cloud::dialogflow::cx::v3::ListTransitionRouteGroupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTransitionRouteGroups(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::GetTransitionRouteGroup(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetTransitionRouteGroupRequest request;
  request.set_name(name);
  return connection_->GetTransitionRouteGroup(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::GetTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::GetTransitionRouteGroupRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTransitionRouteGroup(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::CreateTransitionRouteGroup(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::TransitionRouteGroup const&
        transition_route_group,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateTransitionRouteGroupRequest request;
  request.set_parent(parent);
  *request.mutable_transition_route_group() = transition_route_group;
  return connection_->CreateTransitionRouteGroup(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::CreateTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::CreateTransitionRouteGroupRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTransitionRouteGroup(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::UpdateTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::TransitionRouteGroup const&
        transition_route_group,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateTransitionRouteGroupRequest request;
  *request.mutable_transition_route_group() = transition_route_group;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTransitionRouteGroup(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsClient::UpdateTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::UpdateTransitionRouteGroupRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTransitionRouteGroup(request);
}

Status TransitionRouteGroupsClient::DeleteTransitionRouteGroup(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteTransitionRouteGroupRequest request;
  request.set_name(name);
  return connection_->DeleteTransitionRouteGroup(request);
}

Status TransitionRouteGroupsClient::DeleteTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::DeleteTransitionRouteGroupRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTransitionRouteGroup(request);
}

StreamRange<google::cloud::location::Location>
TransitionRouteGroupsClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
TransitionRouteGroupsClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation>
TransitionRouteGroupsClient::ListOperations(std::string const& name,
                                            std::string const& filter,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
TransitionRouteGroupsClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
TransitionRouteGroupsClient::GetOperation(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
TransitionRouteGroupsClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status TransitionRouteGroupsClient::CancelOperation(std::string const& name,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status TransitionRouteGroupsClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
