// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/page.proto

#include "google/cloud/dialogflow_cx/pages_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PagesClient::PagesClient(std::shared_ptr<PagesConnection> connection,
                         Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
PagesClient::~PagesClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Page> PagesClient::ListPages(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListPagesRequest request;
  request.set_parent(parent);
  return connection_->ListPages(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Page> PagesClient::ListPages(
    google::cloud::dialogflow::cx::v3::ListPagesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPages(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesClient::GetPage(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetPageRequest request;
  request.set_name(name);
  return connection_->GetPage(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesClient::GetPage(
    google::cloud::dialogflow::cx::v3::GetPageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPage(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesClient::CreatePage(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::Page const& page, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreatePageRequest request;
  request.set_parent(parent);
  *request.mutable_page() = page;
  return connection_->CreatePage(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesClient::CreatePage(
    google::cloud::dialogflow::cx::v3::CreatePageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePage(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesClient::UpdatePage(
    google::cloud::dialogflow::cx::v3::Page const& page,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdatePageRequest request;
  *request.mutable_page() = page;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePage(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesClient::UpdatePage(
    google::cloud::dialogflow::cx::v3::UpdatePageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePage(request);
}

Status PagesClient::DeletePage(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeletePageRequest request;
  request.set_name(name);
  return connection_->DeletePage(request);
}

Status PagesClient::DeletePage(
    google::cloud::dialogflow::cx::v3::DeletePageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePage(request);
}

StreamRange<google::cloud::location::Location> PagesClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> PagesClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation> PagesClient::ListOperations(
    std::string const& name, std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation> PagesClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> PagesClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> PagesClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status PagesClient::CancelOperation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status PagesClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
