// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/security_settings.proto

#include "google/cloud/dialogflow_cx/internal/security_settings_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SecuritySettingsServiceTracingStub::SecuritySettingsServiceTracingStub(
    std::shared_ptr<SecuritySettingsServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceTracingStub::CreateSecuritySettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::CreateSecuritySettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService",
      "CreateSecuritySettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->CreateSecuritySettings(context, options, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceTracingStub::GetSecuritySettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetSecuritySettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService",
      "GetSecuritySettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetSecuritySettings(context, options, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceTracingStub::UpdateSecuritySettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::UpdateSecuritySettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService",
      "UpdateSecuritySettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->UpdateSecuritySettings(context, options, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::ListSecuritySettingsResponse>
SecuritySettingsServiceTracingStub::ListSecuritySettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListSecuritySettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService",
      "ListSecuritySettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListSecuritySettings(context, options, request));
}

Status SecuritySettingsServiceTracingStub::DeleteSecuritySettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::DeleteSecuritySettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService",
      "DeleteSecuritySettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DeleteSecuritySettings(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
SecuritySettingsServiceTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService", "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
SecuritySettingsServiceTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService", "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
SecuritySettingsServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService",
      "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
SecuritySettingsServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status SecuritySettingsServiceTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.dialogflow.cx.v3.SecuritySettingsService",
      "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<SecuritySettingsServiceStub>
MakeSecuritySettingsServiceTracingStub(
    std::shared_ptr<SecuritySettingsServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<SecuritySettingsServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
