// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/page.proto

#include "google/cloud/dialogflow_cx/internal/pages_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PagesTracingConnection::PagesTracingConnection(
    std::shared_ptr<dialogflow_cx::PagesConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::dialogflow::cx::v3::Page>
PagesTracingConnection::ListPages(
    google::cloud::dialogflow::cx::v3::ListPagesRequest request) {
  auto span = internal::MakeSpan("dialogflow_cx::PagesConnection::ListPages");
  internal::OTelScope scope(span);
  auto sr = child_->ListPages(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dialogflow::cx::v3::Page>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::dialogflow::cx::v3::Page>
PagesTracingConnection::GetPage(
    google::cloud::dialogflow::cx::v3::GetPageRequest const& request) {
  auto span = internal::MakeSpan("dialogflow_cx::PagesConnection::GetPage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPage(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Page>
PagesTracingConnection::CreatePage(
    google::cloud::dialogflow::cx::v3::CreatePageRequest const& request) {
  auto span = internal::MakeSpan("dialogflow_cx::PagesConnection::CreatePage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreatePage(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Page>
PagesTracingConnection::UpdatePage(
    google::cloud::dialogflow::cx::v3::UpdatePageRequest const& request) {
  auto span = internal::MakeSpan("dialogflow_cx::PagesConnection::UpdatePage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdatePage(request));
}

Status PagesTracingConnection::DeletePage(
    google::cloud::dialogflow::cx::v3::DeletePageRequest const& request) {
  auto span = internal::MakeSpan("dialogflow_cx::PagesConnection::DeletePage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeletePage(request));
}

StreamRange<google::cloud::location::Location>
PagesTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::PagesConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location> PagesTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan("dialogflow_cx::PagesConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StreamRange<google::longrunning::Operation>
PagesTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::PagesConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation> PagesTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::PagesConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status PagesTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::PagesConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dialogflow_cx::PagesConnection> MakePagesTracingConnection(
    std::shared_ptr<dialogflow_cx::PagesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<PagesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
